/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.NamedModelAssembler;
import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.shared.ReificationStyle;

public class RDBModelAssembler
extends NamedModelAssembler
implements Assembler {
    private static final String nameForDefault = "DEFAULT";

    @Override
    protected Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        return this.openModel(a, root, Content.empty, mode);
    }

    @Override
    protected Model openModel(Assembler a, Resource root, Content initial, Mode mode) {
        this.checkType(root, JA.RDBModel);
        String name = this.getModelName(root);
        ReificationStyle style = RDBModelAssembler.getReificationStyle(root);
        ConnectionDescription c = this.getConnection(a, root);
        Model m = this.openModel(root, c, name, style, initial, mode);
        return m;
    }

    protected ConnectionDescription getConnection(Assembler a, Resource root) {
        Resource C2 = RDBModelAssembler.getRequiredResource(root, JA.connection);
        return (ConnectionDescription)a.open(C2);
    }

    protected Model openModel(Resource root, ConnectionDescription c, String name, ReificationStyle style, Content initial, Mode mode) {
        IDBConnection ic = c.getConnection();
        return this.isDefaultName(name) ? (ic.containsDefaultModel() ? ModelRDB.open(ic) : ModelRDB.createModel(ic)) : this.openByMode(root, initial, name, mode, style, ic);
    }

    private Model openByMode(Resource root, Content initial, String name, Mode mode, ReificationStyle style, IDBConnection ic) {
        if (ic.containsModel(name)) {
            if (mode.permitUseExisting(root, name)) {
                return this.consModel(ic, name, style, false);
            }
            throw new AlreadyExistsException(name);
        }
        if (mode.permitCreateNew(root, name)) {
            return initial.fill(this.consModel(ic, name, style, true));
        }
        throw new NotFoundException(name);
    }

    private boolean isDefaultName(String name) {
        return name.equals(nameForDefault) || name.equals("");
    }

    protected Model consModel(IDBConnection c, String name, ReificationStyle style, boolean fresh) {
        return new ModelRDB(this.consGraph(c, name, style, fresh));
    }

    protected GraphRDB consGraph(IDBConnection c, String name, ReificationStyle style, boolean fresh) {
        Graph p = c.getDefaultModelProperties().getGraph();
        int reificationStyle = GraphRDB.styleRDB(style);
        return new GraphRDB(c, name, fresh ? p : null, reificationStyle, fresh);
    }
}

