/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.List;

public class DBReifierGraph
implements Graph {
    protected List<SpecializedGraphReifier> m_specializedGraphs = null;
    protected GraphRDB m_parent = null;

    public DBReifierGraph(GraphRDB parent, List<SpecializedGraphReifier> reifiers) {
        this.m_parent = parent;
        this.m_specializedGraphs = reifiers;
    }

    @Override
    public void add(Triple t) {
        throw new AddDeniedException("cannot add to DB reifier", t);
    }

    @Override
    public void delete(Triple t) {
        throw new DeleteDeniedException("cannot delete from a DB reifier", t);
    }

    @Override
    public int size() {
        this.checkUnclosed();
        int result = 0;
        for (SpecializedGraph specializedGraph : this.m_specializedGraphs) {
            result += specializedGraph.tripleCount();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Triple t) {
        this.checkUnclosed();
        SpecializedGraph.CompletionFlag complete = this.newComplete();
        for (SpecializedGraph specializedGraph : this.m_specializedGraphs) {
            boolean result = specializedGraph.contains(t, this.newComplete());
            if (!result && !complete.isDone()) continue;
            return result;
        }
        return false;
    }

    protected SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        return this.contains(Triple.create(s, p, o));
    }

    @Override
    public GraphStatisticsHandler getStatisticsHandler() {
        return null;
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        this.checkUnclosed();
        ExtendedIterator<Triple> result = NullIterator.instance();
        SpecializedGraph.CompletionFlag complete = this.newComplete();
        for (SpecializedGraph specializedGraph : this.m_specializedGraphs) {
            ExtendedIterator<Triple> partialResult = specializedGraph.find(m, complete);
            result = result.andThen(partialResult);
            if (!complete.isDone()) continue;
            break;
        }
        return result;
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.m_parent.getPrefixMapping();
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.m_parent.getTransactionHandler();
    }

    @Override
    public void close() {
        this.m_specializedGraphs = null;
        this.m_parent = null;
    }

    @Override
    public boolean isClosed() {
        return this.m_specializedGraphs == null;
    }

    private void checkUnclosed() {
        if (this.isClosed()) {
            throw new ClosedException("this DB Reifier has been closed", this);
        }
    }

    @Override
    public GraphEventManager getEventManager() {
        throw new BrokenException("DB reifiers do not yet implement getEventManager");
    }

    @Override
    public boolean dependsOn(Graph other) {
        return this.m_parent.dependsOn(other);
    }

    @Override
    public QueryHandler queryHandler() {
        return new SimpleQueryHandler(this);
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.m_parent.getBulkUpdateHandler();
    }

    @Override
    public Capabilities getCapabilities() {
        return null;
    }

    @Override
    public Reifier getReifier() {
        throw new JenaException("DB Reifier graphs have no reifiers");
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return this.find(Triple.createMatch(s, p, o));
    }

    @Override
    public boolean isIsomorphicWith(Graph g) {
        return g != null && GraphMatcher.equals(this, g);
    }

    public int capabilities() {
        return 0;
    }

    public String toString() {
        return GraphBase.toString("DBReifier ", this);
    }
}

