/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;

public class SimpleCache<K, V>
implements ICache<K, V> {
    protected Map<K, V> cache = CollectionFactory.createHashedMap();
    protected int threshold;
    protected int count = 0;

    public SimpleCache(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void put(K id, V val) {
        if (this.threshold == 0) {
            return;
        }
        if (this.threshold > 0 && this.count >= this.threshold) {
            this.cache = CollectionFactory.createHashedMap();
            this.count = 0;
        }
        ++this.count;
        this.cache.put(id, val);
    }

    @Override
    public V get(K id) {
        return this.cache.get(id);
    }

    @Override
    public void setLimit(int threshold) {
        this.threshold = threshold;
        if (threshold >= 0 && this.count > threshold) {
            this.cache = CollectionFactory.createHashedMap();
            this.count = 0;
        }
    }

    @Override
    public int getLimit() {
        return this.threshold;
    }
}

