/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import com.hp.hpl.jena.rdf.arp.impl.Taint;
import com.hp.hpl.jena.rdf.arp.impl.TaintImpl;
import com.hp.hpl.jena.rdf.arp.impl.XMLContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import org.xml.sax.SAXParseException;

public class XMLBaselessContext
extends AbsXMLContext
implements ARPErrorNumbers {
    final int errno;
    final String errmsg;

    public XMLBaselessContext(XMLHandler f, int eno) {
        this(f, eno, f.sameDocRef());
    }

    XMLBaselessContext(XMLHandler f, int eno, IRI baseURI) {
        super(true, null, baseURI, new TaintImpl(), "", new TaintImpl());
        this.errno = eno;
        switch (this.errno) {
            case 211: {
                this.errmsg = "Base URI is null, but there are relative URIs to resolve.";
                break;
            }
            case 130: {
                this.errmsg = "Base URI is \"\", relative URIs left as relative.";
                break;
            }
            case 214: {
                this.errmsg = "Resolving against bad URI <" + baseURI + ">";
                break;
            }
            case 215: {
                this.errmsg = "Resolving against relative URI <" + baseURI + ">";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown error code: " + eno);
            }
        }
    }

    private XMLBaselessContext(AbsXMLContext document, IRI uri, Taint baseT, String lang, Taint langT, XMLBaselessContext parent) {
        super(true, document, uri, baseT, lang, langT);
        this.errno = parent.errno;
        this.errmsg = parent.errmsg;
    }

    @Override
    AbsXMLContext clone(IRI u, Taint baseT, String lng, Taint langT) {
        return new XMLBaselessContext(this.document, u, baseT, lng, langT, this);
    }

    @Override
    public AbsXMLContext withBase(XMLHandler forErrors, String b) throws SAXParseException {
        TaintImpl taintB = new TaintImpl();
        IRI newB = this.resolveAsURI(forErrors, taintB, b, false);
        if (newB.isRelative()) {
            return new XMLBaselessContext(forErrors, this.errno, newB.create(""));
        }
        if (newB.hasViolation(false)) {
            return new XMLBaselessContext(forErrors, 214, newB);
        }
        return new XMLContext(this.keepDocument(forErrors), this.document, newB.create(""), taintB, this.lang, this.langTaint);
    }

    @Override
    boolean keepDocument(XMLHandler forErrors) {
        return !forErrors.ignoring(3);
    }

    boolean isSameAsDocument() {
        return this == this.document;
    }

    void baseUsed(XMLHandler forErrors, Taint taintMe, String relUri, String string) throws SAXParseException {
        forErrors.warning(taintMe, this.errno, this.errmsg + ": <" + relUri + ">");
    }

    @Override
    void checkBaseUse(XMLHandler forErrors, Taint taintMe, String relUri, IRI rslt) throws SAXParseException {
        String resolvedURI = rslt.toString();
        if (relUri.equals(resolvedURI) && rslt.isAbsolute()) {
            return;
        }
        forErrors.warning(taintMe, this.errno, this.errmsg + ": <" + relUri + ">");
    }
}

