/**
 * 
 */
package org.eaglei.datatools.jena;

import org.eaglei.model.EIURI;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public interface QueryBuilder {

	enum RDFobjectType {
		objectIsLiteral, objectIsResource
	};

	public String getQueryToAddPredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, RDFobjectType objectType, String graph);

	public String getQueryToAddObject(EIURI typeURI, EIURI predicateURI, String oldObjectString, RDFobjectType oldObjectType, String newObjectString, RDFobjectType newObjectType, String graph);

	public String getQueryToDeleteTriple(EIURI typeURI, EIURI predicateURI, String objectString, RDFobjectType objectType, String graph);

	// FIXME:way too many parameters
	public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, RDFobjectType oldObjectType, String newObjectString, RDFobjectType newObjectType, String graph);

	public String diagnoseQuery(EIURI typeURI, EIURI predicateURI, String objectString, RDFobjectType objectType, String graph);

	public String diagnoseQueryByRegex(EIURI typeURI, EIURI predicateURI, String objectString, String graph);

	public String getConstructQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex, String graph);

	public String getSanityCheckQuery(EIURI type, EIURI oldPredicate, String oldObject, RDFobjectType oldObjectType);

	public String diagnoseQueryByRegexForMetadata(EIURI predicateURI, String regex, String graph);

	public String getQueryToDeleteTriplesByRegexForMetadata( EIURI predicateURI, String regex, String graph);
}
