/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.model.EIEntity;
import org.eaglei.model.jena.SPARQLResultsUtil;

public class BulkCurationTripleFactory {
    public static List<BulkCurationTriple> getBulkCurationTriples(ResultSet results) {
        if (results == null) {
            return Collections.emptyList();
        }
        ArrayList<BulkCurationTriple> triples = new ArrayList<BulkCurationTriple>();
        while (results.hasNext()) {
            QuerySolution solution = results.next();
            if (!solution.contains("r_subject") || !solution.contains("r_label")) continue;
            EIEntity resource = SPARQLResultsUtil.getEntityFromSolution((QuerySolution)solution, (String)"r_subject", (String)"r_label");
            EIEntity type = SPARQLResultsUtil.getEntityFromSolution((QuerySolution)solution, (String)"r_type", (String)"r_typeLabel");
            EIEntity predicate = SPARQLResultsUtil.getEntityFromSolution((QuerySolution)solution, (String)"any_predicate", (String)"any_predicateLabel");
            String literalObject = null;
            EIEntity resourceObject = EIEntity.NULL_ENTITY;
            if (solution.contains("r_object")) {
                if (solution.get("r_object").isLiteral()) {
                    literalObject = SPARQLResultsUtil.getStringFromSolution((QuerySolution)solution, (String)"r_object");
                } else if (solution.get("r_object").isResource()) {
                    resourceObject = SPARQLResultsUtil.getEntityFromSolution((QuerySolution)solution, (String)"r_object", (String)"r_objectLabel");
                }
            }
            if (literalObject != null) {
                triples.add(new BulkCurationTriple(resource, type, predicate, literalObject));
                continue;
            }
            if (resourceObject != EIEntity.NULL_ENTITY) {
                triples.add(new BulkCurationTriple(resource, type, predicate, resourceObject));
                continue;
            }
            triples.add(new BulkCurationTriple(resource, type, predicate));
        }
        return triples;
    }
}

