/**
 * The eagle-i consortium
 * Harvard University
 * Apr 7, 2011
 */
package org.eaglei.datatools.jena;

import java.io.Serializable;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

/**
 * @author Daniela Bourges-Waldegg
 *
 * Container for triples used for the diagnosis phase of Bulk Curation.
 * Represents one RDF triple + type information (so two triples in reality)
 */
public class BulkCurationTriple implements Serializable{

	private static final long serialVersionUID = 1L;
	private EIEntity resource;
	private EIEntity type;
	private EIEntity predicate;
	private EIEntity resourceObject;
	private String literalObject;
	private boolean objectIsLiteral;
	
	private BulkCurationTriple(){
		//for GWT
	}
	
	public BulkCurationTriple(EIEntity resource, EIEntity type, EIEntity predicate, EIEntity resourceObject) {
		setCommon( resource, type, predicate );
		this.resourceObject = resourceObject == null? EIEntity.NULL_ENTITY : resourceObject;
		this.literalObject = null;
		this.objectIsLiteral = false;
	}

	/**
	 * @param resource
	 * @param type
	 * @param predicate
	 */
	private void setCommon(EIEntity resource, EIEntity type, EIEntity predicate) {
		this.resource = resource == null? EIEntity.NULL_ENTITY : resource;
		this.type = type == null? EIEntity.NULL_ENTITY : type;
		this.predicate = predicate == null? EIEntity.NULL_ENTITY : predicate;
	}

	public BulkCurationTriple(EIEntity resource, EIEntity type, EIEntity predicate, String literalObject) {
		setCommon( resource, type, predicate );
		this.resourceObject = EIEntity.NULL_ENTITY;
		this.literalObject = literalObject;
		this.objectIsLiteral = true;
	}
	
	public BulkCurationTriple(EIEntity resource, EIEntity type, EIEntity predicate) {
		setCommon( resource, type, predicate );
		this.resourceObject = EIEntity.NULL_ENTITY;
		this.literalObject = null;
		this.objectIsLiteral = false;
	}

	/**
	 * @return the resource
	 */
	public EIEntity getResource() {
		return resource;
	}

	public EIEntity getType() {
		return type;
	}
	
	/**
	 * @return the predicate
	 */
	public EIEntity getPredicate() {
		return predicate;
	}

	/**
	 * @return the resourceObject
	 */
	public EIEntity getResourceObject() {
		return resourceObject;
	}

	/**
	 * @return the literalObject
	 */
	public String getLiteralObject() {
		return literalObject;
	}

	/**
	 * @return the objectIsLiteral
	 */
	public boolean isObjectIsLiteral() {
		return objectIsLiteral;
	}
	
}
