/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.datamanagement;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.DataManagmentProvider;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class BulkCommand {
    private static final Log logger = LogFactory.getLog(BulkCommand.class);
    protected DataManagmentProvider provider;
    protected CommandLine command;
    protected final Options options = new Options();
    protected EIURI type;
    protected String institutionId;
    protected String repo;
    protected String tier;
    protected String[] credentials;
    protected Session session;
    private static final Map<String, String> institutionMap = new HashMap<String, String>(){
        {
            this.put("dartmouth.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_1");
            this.put("harvard.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_2");
            this.put("jsu.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_3");
            this.put("montana.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_4");
            this.put("msm.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_5");
            this.put("ohsu.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_6");
            this.put("alaska.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_7");
            this.put("hawaii.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_8");
            this.put("upr.eagle-i.net", "http://purl.org/eagle-i/app-ext/#ERO_0000065_9");
        }
    };

    protected void initialize() throws RepositoryProviderException {
        System.setProperty("org.eaglei.tier", this.tier);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datamanagement-config.xml"});
        SecurityProvider generalSecurityProvider = (SecurityProvider)context.getBean(SecurityProvider.class);
        this.provider = new DataManagmentProvider(generalSecurityProvider, this.repo);
        this.session = generalSecurityProvider.logIn(this.institutionId, this.credentials[0], this.credentials[1]);
    }

    protected boolean askIfContinue() throws IOException {
        logger.info((Object)("Type: " + this.type));
        logger.info((Object)("Repository: " + this.repo));
        logger.info((Object)("Tier: " + this.tier));
        logger.info((Object)(" Institution ID: " + this.institutionId));
        logger.info((Object)("Username: " + this.credentials[0]));
        logger.info((Object)"=============================================================");
        logger.info((Object)"Continue? y/n");
        logger.info((Object)"");
        Scanner scanner = new Scanner(System.in);
        return scanner.nextLine().equalsIgnoreCase("y");
    }

    protected String getTierFromRepo(String repo) {
        if (repo.startsWith("http")) {
            return repo.substring(repo.lastIndexOf(47) + 1, repo.indexOf("."));
        }
        return repo.substring(0, repo.indexOf(46));
    }

    protected String getInstitutionIdFromRepo(String repo) {
        return institutionMap.get(repo.substring(repo.indexOf(46) + 1, repo.length()));
    }

    protected boolean isLiteral(String object) {
        return object.startsWith("\"") && object.endsWith("\"");
    }

    protected void displayHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Command", options, true);
    }

    protected void setupCommand(String[] args) throws ParseException {
        this.options.addOption("c", true, "credentials in the form username:password");
        this.options.addOption("r", true, "repository URL including http://");
        this.options.addOption("t", true, "Type uri to match for all changes (optional; none means all types)");
    }

    protected boolean validateParams() {
        if (!this.command.hasOption("c") || !this.command.getOptionValue("c").contains(":")) {
            this.displayHelp(this.options);
            return false;
        }
        this.credentials = this.command.getOptionValue("c").split(":");
        if (!this.command.hasOption("r") || !this.command.getOptionValue("r").contains(".")) {
            this.displayHelp(this.options);
            return false;
        }
        this.repo = this.command.getOptionValue("r") + "/";
        this.institutionId = this.getInstitutionIdFromRepo(this.command.getOptionValue("r"));
        this.tier = this.getTierFromRepo(this.command.getOptionValue("r"));
        this.type = this.command.hasOption("t") ? EIURI.create((String)this.command.getOptionValue("t")) : EIURI.NULL_EIURI;
        return true;
    }

    protected abstract void performChanges() throws IOException, RepositoryProviderException;

    protected void setupAndExecuteCommand(String[] args) throws ParseException, RepositoryProviderException, IOException {
        this.setupCommand(args);
        if (!this.validateParams()) {
            return;
        }
        this.initialize();
        if (!this.askIfContinue()) {
            logger.info((Object)"exiting");
            return;
        }
        this.performChanges();
    }
}

