/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.datamanagement;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.datamanagement.BulkCommand;
import org.eaglei.model.EIURI;
import org.eaglei.services.repository.RepositoryProviderException;

public class ChangeObjectCommand
extends BulkCommand {
    static final Log logger = LogFactory.getLog(ChangeObjectCommand.class);
    private EIURI predicate;
    private String filename;

    @Override
    protected void setupCommand(String[] args) throws ParseException {
        super.setupCommand(args);
        this.options.addOption("p", true, "Predicate uri to match for all changes (optional; none means all types)");
        this.options.addOption("f", true, "File name containing translation table for object values; expected: old_value, new_value");
        GnuParser parser = new GnuParser();
        this.command = parser.parse(this.options, args);
    }

    @Override
    protected boolean validateParams() {
        if (!super.validateParams()) {
            return false;
        }
        if (!this.command.hasOption("f")) {
            this.displayHelp(this.options);
            return false;
        }
        this.filename = this.command.getOptionValue("f");
        this.predicate = this.command.hasOption("p") ? EIURI.create((String)this.command.getOptionValue("p")) : EIURI.NULL_EIURI;
        return true;
    }

    @Override
    protected boolean askIfContinue() throws IOException {
        logger.info((Object)"=============================================================");
        logger.info((Object)"Using the following information:");
        logger.info((Object)("Predicate: " + this.predicate));
        logger.info((Object)("File: " + this.filename));
        return super.askIfContinue();
    }

    @Override
    protected void performChanges() throws IOException, RepositoryProviderException {
        String fullName = ClassLoader.getSystemResource(this.filename).getFile();
        CSVReader reader = new CSVReader((Reader)new FileReader(fullName));
        List translations = reader.readAll();
        for (int i = 1; i < translations.size(); ++i) {
            String[] translation = (String[])translations.get(i);
            String oldValue = translation[0];
            String newValue = translation[1];
            logger.info((Object)("replacing: " + oldValue + " with: " + newValue));
            Integer replacements = this.provider.replaceObject(this.session, this.type, this.predicate, oldValue, Boolean.valueOf(this.isLiteral(oldValue)), newValue, Boolean.valueOf(this.isLiteral(newValue)));
            logger.info((Object)("Replaced " + replacements + " occurrences"));
        }
    }
}

