/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.datamanagement;

import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.datamanagement.BulkCommand;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.model.EIURI;
import org.eaglei.services.repository.RepositoryProviderException;

public class DeleteMetadataObjectByRegexCommand
extends BulkCommand {
    static final Log logger = LogFactory.getLog(DeleteMetadataObjectByRegexCommand.class);
    private EIURI predicate;
    private String regex;

    @Override
    protected void setupCommand(String[] args) throws ParseException {
        super.setupCommand(args);
        this.options.addOption("p", true, "Predicate uri to match for all changes (optional; none means all types)");
        this.options.addOption("o", true, "regex to delete in object");
        GnuParser parser = new GnuParser();
        this.command = parser.parse(this.options, args);
    }

    @Override
    protected boolean validateParams() {
        if (!super.validateParams()) {
            return false;
        }
        if (!this.command.hasOption("o")) {
            this.displayHelp(this.options);
            return false;
        }
        this.regex = this.command.getOptionValue("o");
        this.predicate = this.command.hasOption("p") ? EIURI.create((String)this.command.getOptionValue("p")) : EIURI.NULL_EIURI;
        return true;
    }

    @Override
    protected boolean askIfContinue() throws IOException {
        logger.info((Object)"=============================================================");
        logger.info((Object)"Using the following information:");
        logger.info((Object)("Predicate: " + this.predicate));
        logger.info((Object)("Object: " + this.regex));
        return super.askIfContinue();
    }

    @Override
    protected void performChanges() throws IOException, RepositoryProviderException {
        List triples = this.provider.getMetadataResourcesToRepairByRegex(this.session, this.type, this.predicate, this.regex);
        logger.info((Object)"Found the following triples to delete: ");
        for (BulkCurationTriple triple : triples) {
            logger.info((Object)(triple.getResource() + " | " + triple.getPredicate() + " | " + triple.getLiteralObject()));
        }
        logger.info((Object)"=============================================================");
        logger.info((Object)"Continue? y/n");
        logger.info((Object)"");
        Scanner scanner = new Scanner(System.in);
        if (!scanner.nextLine().equalsIgnoreCase("y")) {
            logger.info((Object)"Exiting without changes.");
            return;
        }
        Integer deleted = this.provider.deleteMetadataObjectByRegex(this.session, this.type, this.predicate, this.regex);
        logger.info((Object)("Replaced " + deleted + " occurrences."));
    }
}

