/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.datamanagement;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositorySession;

public final class SimpleRepositorySecurityProvider
extends AbstractRepositoryProvider {
    private static final Log log = LogFactory.getLog(SimpleRepositorySecurityProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();

    public Session logIn(String repositoryUrl, String user, String password) throws RepositoryProviderException {
        HttpClient userClient = this.createHttpClient(user, password);
        userClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        if (isDebugEnabled) {
            log.debug((Object)("Logging in user: " + user));
        }
        return this.getUserInformation(repositoryUrl, null, userClient);
    }

    private HttpClient createHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private Session getUserInformation(String repositoryUrl, RepositorySession repoSession, HttpClient client) throws RepositoryProviderException {
        if (client == null) {
            log.error((Object)"http Client is null");
            throw new RepositoryProviderException("trying to use null http client");
        }
        if (isDebugEnabled) {
            log.debug((Object)("Checking for user info with whoami URL of: " + repositoryUrl));
        }
        ResultSet results = null;
        String responseBody = null;
        GetMethod method = new GetMethod(repositoryUrl + "/repository/whoami");
        try {
            responseBody = ProviderUtils.getHttpResponse((HttpClient)client, (HttpMethod)method);
            if (responseBody == null) {
                throw new RepositoryProviderException("got null responsebody from whoami", RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED);
            }
            results = ResultSetFactory.fromXML((String)responseBody);
            if (results == null) {
                throw new RepositoryProviderException("got null result set from whoami", RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED);
            }
            QuerySolution soln = results.nextSolution();
            Literal username = soln.getLiteral("username");
            Resource userURI = soln.getResource("uri");
            if (username == null || userURI == null) {
                throw new RepositoryProviderException("got null user/usederUri from whoami", RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED);
            }
            if (repoSession == null || !repoSession.isValid()) {
                if (repoSession != null) {
                    SessionManager.removeSession(repoSession.getSessionId());
                }
                String sessionId = UUID.randomUUID().toString();
                Session newSession = new Session(sessionId, repositoryUrl, username.getString(), userURI.getURI());
                repoSession = SessionManager.addSession(client, newSession);
            }
            repoSession.setLastAccess(new Long(System.currentTimeMillis()));
            if (isDebugEnabled) {
                log.debug((Object)("Authenticated user: " + repoSession.getUserName() + " session id: " + repoSession.getSessionId()));
            }
            Session session = repoSession.getInnerSession();
            return session;
        }
        catch (RepositoryProviderException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        finally {
            method.releaseConnection();
        }
    }

    public void logOut(String sessionId) throws RepositoryProviderException {
        RepositorySession repoSession = SessionManager.removeSession(sessionId);
        if (repoSession == null) {
            return;
        }
        PostMethod method = null;
        try {
            method = new PostMethod(repoSession.getInstitutionId() + "/repository/logout/");
            if (isDebugEnabled) {
                log.debug((Object)("Trying to logout at " + repoSession.getInstitutionId()));
            }
            ProviderUtils.getHttpResponse((HttpClient)repoSession.getHttpClient(), (HttpMethod)method);
            if (isDebugEnabled) {
                log.debug((Object)"logout succeded");
            }
        }
        catch (RepositoryProviderException e) {
            log.warn((Object)("Error on logout: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public Session whoami(String sessionId) throws RepositoryProviderException {
        if (!this.isValid(sessionId, false)) {
            log.info((Object)"Using invalid session.  Could not whoami user");
            SessionManager.removeSession(sessionId);
            return null;
        }
        RepositorySession repoSession = SessionManager.getSession(sessionId);
        if (repoSession == null || !repoSession.isValid()) {
            log.info((Object)"Using invalid session.  Could not whoami user");
            SessionManager.removeSession(sessionId);
            return null;
        }
        if (isDebugEnabled) {
            log.debug((Object)("Trying to whoami at " + repoSession.getInstitutionId()));
        }
        return this.getUserInformation(repoSession.getInstitutionId(), repoSession, repoSession.getHttpClient());
    }

    public boolean isValid(String sessionId, boolean shouldThrow) throws RepositoryProviderException {
        if (sessionId == null) {
            if (shouldThrow) {
                throw new RepositoryProviderException("Null session id", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
            }
            log.error((Object)"Null session id");
            return false;
        }
        if (!SessionManager.hasSession(sessionId)) {
            if (shouldThrow) {
                throw new RepositoryProviderException("Invalid Session - non-existent session id", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
            }
            log.error((Object)"Invalid Session - non-existent session id");
            return false;
        }
        RepositorySession repoSession = SessionManager.getSession(sessionId);
        if (repoSession == null || !repoSession.isValid()) {
            if (shouldThrow) {
                throw new RepositoryProviderException("Session invalid or null or client null", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
            }
            log.error((Object)"Session invalid or null or client null");
            return false;
        }
        return true;
    }

    public HttpClient getHttpClient(Session session) {
        RepositorySession repoSession = SessionManager.getSession(session.getSessionId());
        return repoSession == null ? null : repoSession.getHttpClient();
    }

    private EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create((String)solution.getResource(uriVariable).getURI());
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create((EIURI)uri, (String)label);
        }
        return EIEntity.NULL_ENTITY;
    }

    public Session getSession(String sessionId) {
        RepositorySession session = SessionManager.getSession(sessionId);
        return session != null ? session.getInnerSession() : null;
    }

    private static class SessionManager {
        private static Map<String, RepositorySession> mapSessionIdToRepoSession = new HashMap<String, RepositorySession>();

        private SessionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RepositorySession getSession(String sessionId) {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                RepositorySession repoSession = mapSessionIdToRepoSession.get(sessionId);
                if (repoSession == null) {
                    return null;
                }
                return repoSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RepositorySession removeSession(String sessionId) {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                RepositorySession repoSession = mapSessionIdToRepoSession.remove(sessionId);
                if (repoSession == null) {
                    return null;
                }
                if (isDebugEnabled) {
                    log.debug((Object)("Remove session for user: " + repoSession.getUserName() + " session id: " + sessionId));
                }
                return repoSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean hasSession(String sessionId) {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                return mapSessionIdToRepoSession.containsKey(sessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RepositorySession addSession(HttpClient client, Session session) throws RepositoryProviderException {
            RepositorySession newSession = new RepositorySession(session, client);
            if (!newSession.isValid()) {
                throw new RepositoryProviderException("Tried to add repository session with invalid session or null client.");
            }
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                mapSessionIdToRepoSession.put(newSession.getSessionId(), newSession);
            }
            return newSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Set<String> getSessionIdSet() {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                return mapSessionIdToRepoSession.keySet();
            }
        }
    }
}

