/**
 * 
 */
package org.eaglei.datatools.etl.utils;

import java.io.FileNotFoundException;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.User;
import org.eaglei.datatools.etl.server.ETLRepositoryConfiguration;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.jena.FooRepositorySecurityProvider;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.eaglei.security.Session;
import org.eaglei.services.repository.SecurityProvider;
/**
 * @author sc281
 */
public class BulkOperation {

	private static org.apache.log4j.Logger logger = Logger.getLogger( BulkOperation.class );

	private RepoService rdftorepo;
	private Session session;

	public BulkOperation(String repo, EIOntModel ontModel, SecurityProvider securityProvider) throws Exception {
		try {
			
			rdftorepo = RepoService.getInstance( repo, ontModel, securityProvider );
		} catch (FileNotFoundException fe) {
			logger.error( "Repository information file not found" );
			logger.error( fe );
			throw fe;
		}
		FooRepositorySecurityProvider provider = new FooRepositorySecurityProvider( securityProvider );
		Map<String, String> credentialMap = ETLRepositoryConfiguration.getCredentialsForRepo( repo );
		try {
			/* login and get the session */
			User strAry = provider.login( credentialMap.get( "user" ), credentialMap.get( "password" ) );
			if ( strAry == null ) {
				logger.error( "Could not authenticate please check username,password and Repository URL...Exiting System" );
				System.exit( 2 );
			}
			
		} catch (Exception e) {
			logger.error( "Exception thrown in constructor" );
			logger.error( e );
			throw new RuntimeException( e );
		}
	}

	/**
	 * gets the resources Array by making query and queriying it against repository
	 * 
	 * @param fileName
	 * @return
	 */
	public String[] getResourcesOfFile(String fileName) {
		try {
			logger.info( "making delete query for filename" + fileName );
			/* get the query which gives the resources of particular file */
			String query = SPARQLQueryUtil.getInstance().getResourcesETLedFromFileQuery( fileName );
			logger.info( "querying the repository for resources ETLed from " + fileName );
			/* query repository */
			String resources = rdftorepo.getRepositoryProvider().query( rdftorepo.getSession(), query );
			/*
			 * repository returns the xml of resources,parse that xml and make array of resources
			 */
			String[] instanceURIAry = ETLSPARQLQueryUtil.getInstanceURI( resources );
			logger.info( "Query returned " + instanceURIAry.length + " resources" );
			return instanceURIAry;
		} catch (Exception e) {
			logger.error( "exception thrown in getResourcesOfFile()" );
			logger.error( e );
			throw new RuntimeException( e );
		}

	}


	public RepoService getRdftorepo() {
		return rdftorepo;
	}

	


}