package org.eaglei.datatools.etl.utils;

/**
 * @author Sravan Kumar Cheriyala
 * 
 * This class have method which constructs SPARQL Query given the RDF Model
 */
import static org.eaglei.datatools.model.DataToolsOntConstants.RDFS_URI;
import static org.eaglei.datatools.model.DataToolsOntConstants.RDF_URI;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class ETLSPARQLQueryUtil {

	/**
	 * Returns the a sparql query
	 * 
	 * @throws Exception
	 * 
	 */
	private static org.apache.log4j.Logger logger = Logger.getLogger( ETLSPARQLQueryUtil.class );

	public static String getEIResourcesByAllPropertiesQuery(RepositoryProvider provider, Model rdfModel, final Session session) throws Exception {
		final StringBuilder sparql = new StringBuilder();
		EIInstance instance = null;
		sparql.append( "PREFIX rdf: <" );
		sparql.append( RDF_URI );
		sparql.append( "> " );
		sparql.append( "PREFIX rdfs: <" );
		sparql.append( RDFS_URI );
		sparql.append( "> " );
		sparql.append( "SELECT ?resource WHERE {" );
		String query = getEIResourcesByOnlyTypeANDRdfsLabel( rdfModel );
		String result = provider.query( session, query );
		String[] resultAry = getInstanceURI( result );

		try {
			if ( resultAry.length > 0 ) {
				instance = provider.getOneInstance( session, EIURI.create( resultAry[0] ), true );
				
			}
		}
		
		

		catch (RepositoryProviderException e) {
			/* if it came in this block then it must be that Repository has this instance but its the ontology instance */
			logger.info( "ITs an ontology instance" );
			return query;
		} catch (Exception e) {
			e.printStackTrace();
		}

		StmtIterator stmtIterator = rdfModel.listStatements();
		int i = 0;
		while ( stmtIterator.hasNext() ) {

			Statement stmtMap = stmtIterator.nextStatement();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if ( instance != null ) {
				if ( objectMap.isLiteral() ) {
					if ( instance.getNonOntologyLiteralProperties().toString().contains( predicateMap.toString() ) || instance.getReadOnlyLiteralProperties().toString().contains( predicateMap.toString() ) ) {
						continue;
					}
				} else {
					if ( instance.getNonOntologyResourceProperties().toString().contains( predicateMap.toString() ) || instance.getReadOnlyResourceProperties().toString().contains( predicateMap.toString() ) ) {
						continue;
					}
				}
			}
			sparql.append( "?resource <" + predicateMap.getURI() + "> " );
			if ( objectMap.isResource() ) {
				Resource objResource = (Resource)objectMap;
				sparql.append( "	 <" + objResource.getURI() + "> . " );
			} else {
				sparql.append( "?o" + i + " FILTER regex(str(?o" + i + "), \"^" + ETLUtils.forRegex( objectMap.toString() ).split( "\\^\\^" )[0].replace( "\"", "\\\"" ).trim() + "$\", \"i\")." );
			}
			i++;
		}
		sparql.append( "}" );
		return sparql.toString();
	}

	/**
	 * Returns the a sparql query that asks the repo for the URI of a resource of Model
	 * 
	 */
	public static String getEIResourcesQueryButnotWithPassProperty(Model rdfModel, Property property) {
		final StringBuilder sparql = new StringBuilder();
		sparql.append( "PREFIX rdf: <" );
		sparql.append( RDF_URI );
		sparql.append( "> " );
		sparql.append( "PREFIX rdfs: <" );
		sparql.append( RDFS_URI );
		sparql.append( "> " );
		sparql.append( "SELECT ?resource WHERE {" );
		StmtIterator stmtIterator = rdfModel.listStatements();
		int i = 0;
		while ( stmtIterator.hasNext() ) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if ( predicateMap.toString().equals( property.toString() ) ) {
				continue;
			}
			sparql.append( "?resource <" + predicateMap.getURI() + "> " );
			if ( objectMap.isResource() ) {
				Resource objResource = (Resource)objectMap;
				sparql.append( "	 <" + objResource.getURI() + "> . " );
			} else {
				// sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"").trim() + "\", \"i\").");
				// to pass the build
				sparql.append( "?o" + i + " FILTER regex(str(?o" + i + "), \"^" + ETLUtils.forRegex( objectMap.toString() ).split( "\\^\\^" )[0].replace( "\"", "\\\"" ).trim() + "$\", \"i\")." );
			}
			i++;
		}
		sparql.append( "}" );
		return sparql.toString();
	}

	/**
	 * Returns the a sparql query that asks the repo for the URI of a resource of Model ,It builds query of properties containing only rdfs:type and rdfs:lable as predicate
	 * 
	 */
	public static String getEIResourcesByOnlyTypeANDRdfsLabel(Model rdfModel) {
		final StringBuilder sparql = new StringBuilder();
		sparql.append( "PREFIX rdf: <" );
		sparql.append( RDF_URI );
		sparql.append( "> " );
		sparql.append( "PREFIX rdfs: <" );
		sparql.append( RDFS_URI );
		sparql.append( "> " );
		sparql.append( "SELECT ?resource WHERE {" );
		StmtIterator stmtIterator = rdfModel.listStatements();
		while ( stmtIterator.hasNext() ) {
			Statement stmtMap = stmtIterator.nextStatement();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if ( predicateMap.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" ) || predicateMap.getURI().equals( "http://www.w3.org/2000/01/rdf-schema#label" ) ) {
				sparql.append( "?resource <" + predicateMap.getURI() + "> " );
				if ( objectMap.isResource() ) {
					Resource objResource = (Resource)objectMap;
					sparql.append( "	 <" + objResource.getURI() + "> . " );
				} else {
					// sparql.append("?o FILTER regex(str(?o), \"" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"") + "\", \"i\").");
					sparql.append( "?o FILTER regex(str(?o), \"^" + ETLUtils.forRegex( objectMap.toString() ).split( "\\^\\^" )[0].replace( "\"", "\\\"" ) + "$\", \"i\")." );
				}
			}
		}
		sparql.append( "}" );
		return sparql.toString();
	}

	
	
	/**
	 * get instance URI from the returned xml
	 * 
	 * @param xmlString
	 * @return
	 */
	public static String[] getInstanceURI(final String xmlString) {
		if ( xmlString != null ) {
			java.util.regex.Pattern instancePattern = java.util.regex.Pattern.compile( "<uri>([^<]*?)</uri>" );
			java.util.regex.Matcher match = instancePattern.matcher( xmlString );
			List<String> instanceList = new ArrayList<String>();
			while ( match.find() ) {
				int count = match.groupCount();
				for (int i = 1; i <= count; i++) {
					instanceList.add( match.group( i ) );
				}
			}

			return instanceList.toArray( new String[instanceList.size()] );

		} else {
			return null;
		}
	}
}
