/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.cores;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.cores.Cores3ExcelParser;
import org.eaglei.datatools.interim.cores.Cores3Model;
import org.eaglei.datatools.interim.cores.OldFileUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Cores3RDFGenerator {
    private static final Log logger = LogFactory.getLog(Cores3RDFGenerator.class);

    public static void main(String[] args) throws Exception {
        if (args.length <= 1 || args[0].length() == 0 || args[1].length() == 0) {
            logger.error((Object)"Cores3RDFGenerator <Excel file> <output dir> [RDF/XML | N-TRIPLE]");
            return;
        }
        String format = "RDF/XML";
        if (args.length > 2 && args[2] != null && args[2].length() > 0) {
            if (!"RDF/XML".equals(args[2]) && !"N-TRIPLE".equals(args[2])) {
                logger.error((Object)("Unsupported format: " + args[2]));
            } else {
                format = args[2];
            }
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
        OntModel datatoolsJenaOntModel = (OntModel)context.getBean("datatoolsJenaOntModel", OntModel.class);
        Cores3RDFGenerator.generateToFile(args[0], args[1], format, datatoolsJenaOntModel);
    }

    public static Model generateToModel(String excel, OntModel datatoolsJenaOntModel) throws IOException {
        if (!excel.endsWith(".xlsx") || excel.startsWith("~$")) {
            throw new IllegalArgumentException("Expecting an Excel file");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reading Excel file: " + excel));
        }
        Cores3ExcelParser parser = new Cores3ExcelParser(excel);
        Cores3Model core = new Cores3Model(datatoolsJenaOntModel);
        List<Cores3ExcelParser.ProcessedTab> processedTabs = parser.getProcessedTabs();
        for (Cores3ExcelParser.ProcessedTab p : processedTabs) {
            List<Map<String, String>> tabData = p.getTabData();
            for (Map<String, String> columns : tabData) {
                core.createResourceInstance(p.getClassMapping(), columns);
            }
        }
        return core.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateToFile(String excel, String outputPath, String format, OntModel datatoolsJenaOntModel) throws IOException {
        Model generatedModel = Cores3RDFGenerator.generateToModel(excel, datatoolsJenaOntModel);
        File outputDir = new File(outputPath);
        OldFileUtils.validateDirectory(outputDir, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing RDF data to directory: " + outputDir.getAbsolutePath()));
        }
        String extension = null;
        if ("RDF/XML".equals(format)) {
            extension = ".rdf";
        } else if ("N-TRIPLE".equals(format)) {
            extension = ".ntriple";
        }
        File excelFile = new File(excel);
        int i = excelFile.getName().lastIndexOf(".");
        String rdfFile = i > 0 ? excelFile.getName().substring(0, i) + extension : excelFile.getName() + extension;
        FileOutputStream os = new FileOutputStream(new File(outputDir, rdfFile));
        try {
            generatedModel.write((OutputStream)os, format);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        logger.info((Object)"Done!");
    }
}

