/**
 * 
 */
package org.eaglei.datatools.etl.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;

/**
 * @author "Sravan Cheriyala" Started Mar 9, 2011
 */
public class BROOntologyReasoner {

	OntModel ontModel;

	public BROOntologyReasoner() throws FileNotFoundException {
		ontModel = ModelFactory.createOntologyModel( OntModelSpec.OWL_MEM, null );
		FileInputStream mapStream = new FileInputStream( BROOntologyReasoner.class.getClassLoader().getResource( "BRO.owl" ).getFile() );
		Model mapModel = ModelFactory.createDefaultModel();
		mapModel.read( mapStream, "RDF/XML" );
		mapModel.removeNsPrefix( "" );
		ontModel.add( mapModel );
		
	}

	public boolean isSubClass(String ancestorURI, String descendentURI) {
		OntClass ancestorOntClass = getOntologyClass( ancestorURI );
		OntClass descendentClass =getOntologyClass( descendentURI );
		if(!ancestorOntClass.hasSubClass( descendentClass))
		{
			Iterator<OntClass> ontIterator=ancestorOntClass.listSubClasses();
			while(ontIterator.hasNext())
			{
				OntClass subOntClass = ontIterator.next();
				
				if(isSubClass(subOntClass.getURI(),descendentURI))
				{
					return true;
				}
			}
			return false;
		}
		else
		{
			return true;
		}
		
		
		
		
		
	}

	
	
	
	private OntClass getOntologyClass(String strURI) {
		return ontModel.getOntClass( strURI );
	}
	
	public String getEagleIResource(String broResource)
	{
		
		if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Funding_Resource", broResource ))
		{
			return "http://purl.obolibrary.org/obo/OBI_0000245";
		}
		else if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Information_Resource", broResource ))
		{
			return "http://purl.obolibrary.org/obo/ERO_0000071";
		}
		else if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Material_Resource", broResource ) && 
				!isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Facility_Core", broResource )){
			return "http://purl.obolibrary.org/obo/ERO_0000004";
			
		}
		else if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Facility_Core", broResource ))
		{
			return "http://purl.obolibrary.org/obo/ERO_0000002";
		}
		else if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#People_Resource", broResource )
				|| isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Service_Resource", broResource ) || isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Training_Resource", broResource ) && !isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Facility_Core", broResource ))
		{
			return "http://purl.obolibrary.org/obo/ERO_0000005";
		}
		else if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Software", broResource ))
		{
			return "http://purl.obolibrary.org/obo/ERO_0000071";
		}
		else if(isSubClass( "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Deprecated_Resource", broResource ))
		{
			return "http://purl.obolibrary.org/obo/IAO_0000310";
		}
		else
		{
			//Hack
			return "http://purl.obolibrary.org/obo/ERO_0000071";
		}
		
	}

}
