package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.poi.ss.usermodel.Sheet;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;
import org.eaglei.datatools.etl.server.extractor.parsers.excelparsers.ExcelFileParser;

/**
 * 
 * @author Sravan Cheriyala
 * 
 */

public class ExcelExtractor extends Extractor {

	File excelFile;
	final ExcelFileParser fileParser;

	public ExcelExtractor(File excelFile) throws ParseException {
		this.excelFile = excelFile;
		fileParser = new ExcelFileParser( excelFile );

	}

	@Override
	public Map<String, Data> getData(File mapDirectory) throws ConfigurationException, IOException, ParseException {
		final Map<String, Data> mapToReturn = fileParser.parse( mapDirectory );
		return mapToReturn;
	}

	@Override
	public String getFormVersion() throws ParseException {
		return fileParser.getFormVersion( getLabSheet() );
	}

	private Sheet getLabSheet() {
		return fileParser.getLabSheet();
	}

}
