package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;

/**
 * 
 * 
 * 
 * @author Sravan Cheriyala
 */
public abstract class Extractor {

	/**
	 * Every File which is submitted to ETL have to be associated with the form version. This form version is either submitted from within the file or as one of the input to ETL . If Form Version submitted from within the file then we need to write
	 * the file parser in such a way so that it reads the from version . The FormVersion decides which version of map file should be used to transform the data.
	 * 
	 * @return the version string
	 * @throws ParseException
	 * @throws IOException
	 */
	public abstract String getFormVersion() throws ParseException, IOException;

	/**
	 * We need to parse the file and convert the data into {@link #org.eaglei.datatools.etl.server.extractor.parsers.data} . This method returns the Java.util.Map with 'key' as the name of Map file and 'value' as the Data.It needs template config file as input. This templateconfig will be having
	 * information about the file being extracted.
	 * 
	 * @param templateConfigFile
	 * @return
	 * @throws ConfigurationException
	 * @throws IOException
	 * @throws ParseException
	 * @throws ExtractorException
	 */
	public abstract Map<String, Data> getData(File templateConfigFile) throws ConfigurationException, IOException, ParseException, ExtractorException;

	/**
	 * gets all the map files require to transform the extracted file,returns the java.Util.Map with 'key' as map filename and 'value' as Map File
	 * 
	 * @param mapDirectory
	 * @return
	 * @throws FileNotFoundException
	 */

	public Map<String, File> getMapFiles(File mapDirectory) throws FileNotFoundException {
		final Map<String, File> mapIns = new HashMap<String, File>();

		final String[] lstMapFiles = mapDirectory.list();

		for (final String mapFileName : lstMapFiles) {
			if ( mapFileName.contains( ".svn" ) ) {
				continue;
			}
			File mapFile = new File( mapDirectory.getPath() + "/" + mapFileName );
			mapIns.put( mapFileName.replace( ".rdf", "" ).toUpperCase(), mapFile );
		}

		return mapIns;
	}

	/**
	 * Map directories are named with following format RESOURCETYPE_VERSION.In this directory all map files are stored . 
	 * This method will return the map directory.
	 * 
	 * @param formVersion
	 * @param mapsParentDirectory
	 * @return
	 */

	public File getMapDirectory(String formVersion, File mapsParentDirectory) {
		return new File( mapsParentDirectory.getPath() + "/" + formVersion );
	}

}
