/**
 * 
 */
package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;
import org.eaglei.datatools.etl.server.extractor.parsers.xmlparser.XmlFileParser;
import org.xml.sax.SAXException;

/**
 * @author "Sravan Cheriyala" Started Mar 1, 2011
 */
public class XmlExtractor extends Extractor {

	File xmlFile;
	final XmlFileParser fileParser;
	final String version;

	public XmlExtractor(File xmlFile, String version) throws ParseException, ParserConfigurationException, SAXException, IOException {
		this.xmlFile = xmlFile;
		this.version = version;
		fileParser = new XmlFileParser( xmlFile );
	}

	@Override
	public Map<String, Data> getData(File mapDirectory) throws ConfigurationException, IOException, ParseException, ExtractorException {

		return fileParser.parse( mapDirectory );
	}

	@Override
	public String getFormVersion() throws ParseException, IOException {
		return version;
	}

}
