package org.eaglei.datatools.etl.server.extractor.parsers.excelparsers;

/**
 * @author Sravan Kumar Cheriyala
 * 
 * This class has methods for read from properties file
 */
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eaglei.datatools.etl.server.extractor.parsers.MapFileConfiguration;

public class ExcelTemplateConfiguration {
	/**
	 * Reads the content of rowInfo.prperties file
	 * 
	 * @param mapPath
	 * @param tab
	 * @return
	 * @throws ConfigurationException
	 */
	public static Map<String, String> getFormatingInfoOfRow(String mapPath, String tab) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration( mapPath + "/mapfileinfo.properties" );
		Integer startrow = config.getInteger( tab.toLowerCase() + ".startrow", 1 );
		rowInfoMap.put( "startrow", startrow + "" );
		Integer rowheadStart = config.getInteger( tab + ".rowheadstart", 1 );
		rowInfoMap.put( "rowheadstart", rowheadStart + "" );
		String order = config.getString( "process.order" );
		rowInfoMap.put( "order", order );
		String globalColumns = config.getString( "globalcolumnsorderintoCSV" );
		if ( globalColumns != null ) {
			rowInfoMap.put( "globalcolumnsorderintoCSV", globalColumns );
		}
		String globalColumnsOrder = config.getString( "globalcolumnsorderinexcel" );
		if ( globalColumnsOrder != null ) {
			rowInfoMap.put( "globalcolumnsorderinexcel", globalColumnsOrder );
		}
		return rowInfoMap;
	}

	public static Map<String, String> getFormatingInfoOfFile(String mapPath) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration( mapPath + "/mapfileinfo.properties" );

		String order = config.getString( "process.order" );
		rowInfoMap.put( "order", order );
		String globalColumns = config.getString( "globalcolumnsorderintoCSV" );
		if ( globalColumns != null ) {
			rowInfoMap.put( "globalcolumnsorderintoCSV", globalColumns );
		}
		String globalColumnsOrder = config.getString( "globalcolumnsorderinexcel" );
		if ( globalColumnsOrder != null ) {
			rowInfoMap.put( "globalcolumnsorderinexcel", globalColumnsOrder );
		}
		return rowInfoMap;
	}

}
