/**
 * 
 */
package org.eaglei.datatools.etl.server.loader;

import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.utils.ETLSPARQLQueryUtil;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.model.DataToolsOntConstants;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.eaglei.services.repository.RepositoryProviderException;

/**
 * @author Sravan Cheriyala
 * 
 */
public class Validation {
	private static org.apache.log4j.Logger logger = Logger.getLogger( Validation.class );
	private RepoService repoService;

	public Validation(RepoService repoService) {
		this.repoService = repoService;
	}

	public boolean isInstanceLableAndTypeAlreadyExsistsInRepository(final EIInstance instance) throws Exception {
		try {
			String query = SPARQLQueryUtil.getInstance().getEIResourcesByLabelQuery( instance.getInstanceType().getURI(), instance.getInstanceLabel() );
			final String results = repoService.query( query.replace( "\n", " " ).replace( "\r", " " ) );
			final String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI( results );
			return instanceURI.length > 0;
		} catch (final RepositoryProviderException ex) {
			logger.error( ex.getMessage() );
			logger.error( "the offending instnace is " + instance.getInstanceType().getURI() );
			logger.info( "skiping..." );
			throw ex;
		}
	}

	public boolean isLab(EIInstance instance) {
		EIClass instanceClass = instance.getInstanceClass();
		if ( instanceClass.getEntity().getURI().toString().equals( DataToolsOntConstants.EI_LAB ) ) {
			return true;
		}
		List<EIClass> superEIClassList = instanceClass.getSuperClasses();
		if ( superEIClassList == null ) {
			return false;
		}
		for (EIClass superClass : superEIClassList) {
			if ( superClass.getEntity().getURI().toString().equals( DataToolsOntConstants.EI_LAB ) ) {
				return true;
			}
		}
		return false;
	}

	public boolean isEmbeddedClass(EIClass eiClass,EIOntModel eiOntModel) {	
		Set<String> annotationSet=eiOntModel.getClassAnnotations( eiClass.getEntity().getURI() );
		// if not annotated then its not embedded
		if ( annotationSet == null ) {
			return false;
		}
		for (String annotationString : annotationSet) {
			if ( annotationString.contains( DataToolsOntConstants.EMBEDDED_ANNOTATION ) ) {
				return true;
			}
		}
		return false;
		}

	
	
}
