package org.eaglei.datatools.etl.server.transformer;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.utils.ETLUtils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
/**
 * 
 * @author Sravan Cheriyala
 *
 */
class ObjectLiteralExpression extends Expression<Statement[]> {

	private String literalExpression;
	private  Map<String,String> columnMap;
	private Statement mapStatement;
	public static final String OBJECT_LITERAL_EXPRESSION_MATCHER = "Ex:$";
	private static org.apache.log4j.Logger logger = Logger.getLogger( ObjectLiteralExpression.class );


	public ObjectLiteralExpression(final String literalExpression,final Statement mapStatement,final Map<String,String> columnMap) {
		this.literalExpression = literalExpression;
		this.columnMap = columnMap;
		this.mapStatement = mapStatement;
		

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.CSVToRDFGraph.AbstractExpression# Interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int, com.clarkparsia.pellint.rdfxml.RDFModel)
	 */
	@Override
	public Statement[] interpret() {
		try {
			//FIXME: remove need for row index
			String result = ETLUtils.evaluateExpression(columnMap, literalExpression.toString() );
			if ( result == null || result.equals( "" ) ) {
				return null;
			}
			Model m = ModelFactory.createDefaultModel();

			String[] stringAry = result.split( ";" );
			Statement[] statementAry = new Statement[stringAry.length];
			int i = 0;
			for (String resultStr : stringAry) {
				RDFNode object = m.createResource( resultStr );
				Statement stmt ;
				
				if(resultStr.startsWith( "http://" ))
				{
					
					stmt	= m.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), object );
				}
				else
				{
					stmt	= m.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), resultStr );
				}
				
				
				
				statementAry[i] = stmt;
				i++;
			}

			return statementAry;

			// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
		} catch (Exception e) {
			logger.error( "Exception has raised in ObjectLiteralExpression's interpret method" );
			e.printStackTrace();
			throw new RuntimeException( e );
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {
		// TODO Auto-generated method stub
		return literalExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
	 */
	@Override
	public Statement getExpressionStatement() {
		// TODO Auto-generated method stub
		return mapStatement;
	}

}
