package org.eaglei.datatools.etl.server.transformer;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.etl.server.exceptions.TransformException;
import org.eaglei.services.repository.RepositoryProviderException;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;

/**
 * 
 * Transform the Data into Rdf statements
 * 
 * @author Sravan Cheriyala
 */

public interface Transformer {
	public static final String SYNTAX = "RDF/XML";

	/**
	 * The dataMap is a java.util.Map with 'key' as Expression from map file and values is the value read from the extracted file using that expression.
	 * 
	 * @param dataMap
	 * @param mapFile
	 * @return Statement[]
	 * @throws TransformException
	 * @throws RepositoryProviderException
	 */
	public Statement[] transformToRDF(Map<String, String> dataMap, File mapFile) throws TransformException, RepositoryProviderException;
}
