/**
 * eagle-i Project
 * Harvard University
 * Feb 18, 2010
 */
package org.eaglei.datatools.interim.cores;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class Cores3BatchRDFGenerator {
	private static final Log logger = LogFactory.getLog(Cores3BatchRDFGenerator.class);
	
	//Directories
	public static void main(String[] args) throws Exception {
		if (args.length <= 1 || args[0].length() == 0 || args[1].length() == 0) {
			logger.error("Cores3Batch RDFGenerator <input dir> <output dir> [RDF/XML | N-TRIPLE]");
			return;
		}
		String format = "RDF/XML";
		//defaults to RDF/XML
		if(args.length >2 && args[2] != null && args[2].length() > 0)
			if(!"RDF/XML".equals(args[2]) && !"N-TRIPLE".equals(args[2]))
				logger.error("Unsupported format: " + args[2]);
			else
				format = args[2];
        // create and configure spring beans
        ApplicationContext context =
            new ClassPathXmlApplicationContext(new String[] {"datatools-model-config.xml"});
        // retrieve configured instance
        OntModel datatoolsJenaOntModel = context.getBean("datatoolsJenaOntModel", OntModel.class);
		generate(args[0], args[1], format, datatoolsJenaOntModel);
	}

	private static void generate(String inputPath, String outputPath, String format, OntModel datatoolsJenaOntModel) throws IOException {
		final File inputDir = new File(inputPath);
		if(logger.isDebugEnabled())logger.debug("Reading Excel data from directory: " + inputDir.getAbsolutePath());

		// check if directory exists
		OldFileUtils.validateDirectory(inputDir, false);
		List<File> files = OldFileUtils.getAllFiles(inputDir);
		for(File file : files) {
			final String excelFile = file.getAbsolutePath();
			Cores3RDFGenerator.generateToFile(excelFile, outputPath, format, datatoolsJenaOntModel);
		}
	}
}


