/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.gsites;

import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.Query;
import com.google.gdata.client.sites.ContentQuery;
import com.google.gdata.client.sites.SitesService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.ILink;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.sites.AttachmentEntry;
import com.google.gdata.data.sites.BaseContentEntry;
import com.google.gdata.data.sites.ContentFeed;
import com.google.gdata.data.sites.FileCabinetPageEntry;
import com.google.gdata.data.sites.WebPageEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.cores.OldFileUtils;
import org.eaglei.datatools.interim.gsites.GSitesConstants;

public class GSitesUtils {
    private static final Log logger = LogFactory.getLog(GSitesUtils.class);
    private static SitesService client;
    private static MimetypesFileTypeMap mediaTypes;
    private static String separator;

    private static String getEntryId(BaseContentEntry<?> entry) {
        String selfLink = entry.getSelfLink().getHref();
        return selfLink.substring(selfLink.lastIndexOf("/") + 1);
    }

    private static String getEntryId(String selfLink) {
        return selfLink.substring(selfLink.lastIndexOf("/") + 1);
    }

    public static void login() {
        client = new SitesService("eagle-i.org-Downloader-v1");
        try {
            client.setUserCredentials("daemon@eagle-i.org", "amp3id1wut", ClientLoginAccountType.HOSTED);
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
    }

    public static void getAttachments(String basePath, boolean delete) throws IOException, ServiceException {
        for (String rnav : GSitesConstants.RNAVS) {
            GSitesUtils.getAttachmentsForRnav(rnav, basePath, delete);
        }
    }

    public static void setAttachments(String basePath) throws IOException, ServiceException {
        for (String rnav : GSitesConstants.RNAVS) {
            GSitesUtils.setAttachmentsForRnav(rnav, basePath);
        }
    }

    public static void getDropboxes(String basePath, boolean delete) throws IOException, ServiceException {
        for (String rnav : GSitesConstants.RNAVS) {
            GSitesUtils.getDropboxForRnav(rnav, basePath, delete);
        }
    }

    public static void getAttachmentsForRnav(String rnav, String basePath, boolean delete) throws IOException, ServiceException {
        URL url = new URL(" https://sites.google.com/feeds/content/eagle-i.org/workspace/");
        ContentQuery query = new ContentQuery(url);
        query.setPath("/interim-data-collection/" + rnav);
        query.setKind("webpage");
        ContentFeed contentFeed = (ContentFeed)client.getFeed((Query)query, ContentFeed.class);
        for (BaseContentEntry p : contentFeed.getEntries()) {
            String ID = p.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inspecting page: " + p.getTitle().getPlainText()));
                logger.debug((Object)("Page has ID: " + ID));
            }
            WebPageEntry page = new WebPageEntry((BaseEntry)p);
            String relPath = page.getPageName().getValue();
            if (!basePath.endsWith(separator)) {
                GSitesUtils.getAttachmentsAtPath(GSitesUtils.getEntryId(ID), basePath + separator + relPath, delete);
                continue;
            }
            GSitesUtils.getAttachmentsAtPath(GSitesUtils.getEntryId(ID), basePath + relPath, delete);
        }
    }

    public static void setAttachmentsForRnav(String rnav, String basePath) throws IOException, ServiceException {
        URL url = new URL(" https://sites.google.com/feeds/content/eagle-i.org/workspace/");
        String rnavPath = basePath + separator + rnav;
        File rnavDir = new File(rnavPath);
        OldFileUtils.validateDirectory((File)rnavDir, (boolean)false);
        String[] extensions = new String[]{"xlsx", "xls"};
        Collection files = FileUtils.listFiles((File)rnavDir, (String[])extensions, (boolean)true);
        for (File file : files) {
            String parentPath;
            int i;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing file: " + file.getAbsolutePath()));
            }
            if ((i = (parentPath = file.getParent()).indexOf(rnav)) <= 0) {
                throw new IOException("rnav subdirectory not found in path");
            }
            String urlFragment = parentPath.substring(i);
            String parentUrl = "/interim-data-collection/" + urlFragment;
            ContentQuery query = new ContentQuery(url);
            query.setPath(parentUrl);
            ContentFeed contentFeed = (ContentFeed)client.getFeed((Query)query, ContentFeed.class);
            for (BaseContentEntry p : contentFeed.getEntries()) {
                String ID = p.getId();
                BaseContentEntry pageEntry = p;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Inspecting page: " + p.getTitle().getPlainText()));
                    logger.debug((Object)("Page has ID: " + ID));
                }
                AttachmentEntry newAttachment = new AttachmentEntry();
                newAttachment.setMediaSource((MediaSource)new MediaFileSource(file, mediaTypes.getContentType(file)));
                String fileName = file.getName();
                newAttachment.setTitle((TextConstruct)new PlainTextConstruct(fileName));
                newAttachment.addLink("http://schemas.google.com/sites/2008#parent", ILink.Type.ATOM, pageEntry.getSelfLink().getHref());
                client.insert(url, (IEntry)newAttachment);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Attachment uploaded");
            }
        }
    }

    public static void getDropboxForRnav(String rnav, String basePath, boolean delete) throws IOException, ServiceException {
        BaseContentEntry<?> p = GSitesUtils.getBaseContentEntry(rnav + "/" + "dropbox");
        if (p == null) {
            return;
        }
        String rnavPath = basePath + separator + rnav;
        OldFileUtils.validateDirectory((String)rnavPath, (boolean)true);
        WebPageEntry page = new WebPageEntry(p);
        String relPath = rnav + separator + page.getPageName().getValue();
        String ID = p.getId();
        if (!basePath.endsWith(separator)) {
            GSitesUtils.getAttachmentsAtPath(GSitesUtils.getEntryId(ID), basePath + separator + relPath, delete);
        } else {
            GSitesUtils.getAttachmentsAtPath(GSitesUtils.getEntryId(ID), basePath + relPath, delete);
        }
    }

    private static BaseContentEntry<?> getBaseContentEntry(String urlFragment) throws IOException, ServiceException {
        URL url = new URL(" https://sites.google.com/feeds/content/eagle-i.org/workspace/");
        ContentQuery query = new ContentQuery(url);
        query.setPath("/interim-data-collection/" + urlFragment);
        query.setKind("webpage");
        ContentFeed contentFeed = (ContentFeed)client.getFeed((Query)query, ContentFeed.class);
        Iterator i$ = contentFeed.getEntries().iterator();
        if (i$.hasNext()) {
            BaseContentEntry p = (BaseContentEntry)i$.next();
            String ID = p.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inspecting page: " + p.getTitle().getPlainText()));
                logger.debug((Object)("Page has ID: " + ID));
            }
            return p;
        }
        return null;
    }

    private static void getAttachmentsAtPath(String node, String relPath, boolean delete) throws IOException, ServiceException {
        OldFileUtils.validateDirectory((String)relPath, (boolean)true);
        URL url = new URL(" https://sites.google.com/feeds/content/eagle-i.org/workspace/");
        ContentQuery query = new ContentQuery(url);
        query.setParent(node);
        query.setKind("attachment");
        ContentFeed atContentFeed = (ContentFeed)client.getFeed((Query)query, ContentFeed.class);
        for (BaseContentEntry att : atContentFeed.getEntries()) {
            String u = ((OutOfLineContent)att.getContent()).getUri();
            String fileName = att.getTitle().getPlainText();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Downloading file: " + fileName));
                logger.debug((Object)("At URL: " + u));
            }
            GSitesUtils.downloadAttachment(u, relPath, att.getTitle().getPlainText());
            if (!delete) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Deleting attachment");
            }
            att.delete();
        }
        query.setKind("webpage");
        ContentFeed wpContentFeed = (ContentFeed)client.getFeed((Query)query, ContentFeed.class);
        for (BaseContentEntry wp : wpContentFeed.getEntries()) {
            WebPageEntry w = new WebPageEntry((BaseEntry)wp);
            String ID = GSitesUtils.getEntryId(wp.getId());
            String name = w.getPageName().getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inspecting subpage " + name));
                logger.debug((Object)("Subpage ID: " + ID));
            }
            if (!relPath.endsWith(separator)) {
                GSitesUtils.getAttachmentsAtPath(ID, relPath + separator + name, delete);
                continue;
            }
            GSitesUtils.getAttachmentsAtPath(ID, relPath + name, delete);
        }
        query.setKind("filecabinet");
        ContentFeed fcContentFeed = (ContentFeed)client.getFeed((Query)query, ContentFeed.class);
        for (BaseContentEntry fc : fcContentFeed.getEntries()) {
            FileCabinetPageEntry f = new FileCabinetPageEntry((BaseEntry)fc);
            String ID = GSitesUtils.getEntryId(fc.getId());
            String name = f.getPageName().getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inspecting subpage " + name));
                logger.debug((Object)("Subpage ID: " + ID));
            }
            if (!relPath.endsWith(separator)) {
                GSitesUtils.getAttachmentsAtPath(ID, relPath + separator + name, delete);
                continue;
            }
            GSitesUtils.getAttachmentsAtPath(ID, relPath + name, delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadAttachment(String uri, String dir, String fileName) throws IOException, ServiceException {
        OldFileUtils.validateDirectory((String)dir, (boolean)true);
        String fullFilePath = !dir.endsWith(separator) ? dir + separator + fileName : dir + fileName;
        MediaContent mc = new MediaContent();
        mc.setUri(uri);
        MediaSource ms = client.getMedia((IMediaContent)mc);
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int c;
            inStream = ms.getInputStream();
            outStream = new FileOutputStream(fullFilePath);
            while ((c = inStream.read()) != -1) {
                outStream.write(c);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
    }

    static {
        mediaTypes = new MimetypesFileTypeMap();
        mediaTypes.addMimeTypes("application/vnd.ms-excel xlsx");
        mediaTypes.addMimeTypes("application/vnd.openxmlformats docx pptx xlsx");
        separator = System.getProperty("file.separator");
    }
}

