package org.eaglei.datatools.model;

import java.util.Deque;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class DataToolsEIOntModel implements EIOntModel {

    protected static final Log logger = LogFactory.getLog(DataToolsEIOntModel.class);
    
    /**
     * This is a bad, bad hack.  Assumes that some spring aware code sets
     * this static at app startup.
     * TODO client code should be updated to get the ref in a spring way.
     */
    public static DataToolsEIOntModel INSTANCE;
    
    private final EIOntModel eagleiOntModel;
    
    public DataToolsEIOntModel(EIOntModel eagleiOntModel)
    {
    	this.eagleiOntModel = eagleiOntModel;
    }

	@Override
	public String generateStackTrace(Deque<String> stack) {
		return eagleiOntModel.generateStackTrace(stack);
	}

	@Override
	public EIClass getClass(EIURI classId) {
		if (! isModelClassURI(classId.toString()))
			return null;
		return eagleiOntModel.getClass(classId);
	}

	@Override
	public String getClassDefinition(EIURI uri) {
		return eagleiOntModel.getClassDefinition(uri);
	}

	@Override
	public List<String> getClassDefinitions(List<EIURI> classURIs) {
		return eagleiOntModel.getClassDefinitions(classURIs);
	}

	@Override
	public List<EIEntity> getInstitutions() {
		return eagleiOntModel.getInstitutions();
	}

	@Override
	public List<String> getLabels(EIURI uri) {
		return eagleiOntModel.getLabels(uri);
	}

	@Override
	public List<EIClass> getNonResourceBaseClasses() {
		return eagleiOntModel.getNonResourceBaseClasses();
	}

	@Override
	public String getPreferredLabel(EIURI uri) {
		return eagleiOntModel.getPreferredLabel(uri);
	}

	@Override
	public List<EIProperty> getProperties(EIURI classId) {
		return eagleiOntModel.getProperties(classId);
	}
	
	public List<EIProperty> getProperties(final EIURI classId, final String groupURI)
	{
	    // TODO promote this method to the public interface?
		return ((JenaEIOntModel) eagleiOntModel).getProperties(classId, groupURI);
	}

    @Override
    public List<EIEquivalentClass> getEquivalentClasses(EIURI classId) {
        return eagleiOntModel.getEquivalentClasses(classId);
    }
    
	@Override
	public String getPropertyDefinition(EIURI uri) {
		return eagleiOntModel.getPropertyDefinition(uri);
	}

	@Override
	public List<String> getPropertyDefinitions(List<EIURI> propertyURIs) {
		return eagleiOntModel.getPropertyDefinitions(propertyURIs);
	}

	@Override
	public List<EIClass> getSubClasses(EIURI classId) {
		return eagleiOntModel.getSubClasses(classId);
	}

	@Override
	public EIClass getSuperClass(EIClass childClass) {
		return eagleiOntModel.getSuperClass(childClass);
	}

	@Override
	public List<EIClass> getTopLevelClasses() {
		return eagleiOntModel.getTopLevelClasses();
	}

	@Override
	public String getVersion() {
		return eagleiOntModel.getVersion();
	}

	@Override
	public boolean isModelClassURI(String uri) {
		return eagleiOntModel.isModelClassURI(uri);
	}

	@Override
	public void traverseDataModel(List<Visitor> visitors) {
		eagleiOntModel.traverseDataModel(visitors);
	}

    @Override
    public List<EIClass> getSuperClasses(EIURI classId) {
        return eagleiOntModel.getSuperClasses(classId);
    }

}
