/**
 * eagle-i Project
 * Harvard University
 * Apr 25, 2010
 */
package org.eaglei.datatools.model;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public final class DataToolsOntConstants {
	// Namespaces and prefixes
	public static final String OBO_URI = "http://purl.obolibrary.org/obo/";

	public static final String EAGLE_I_PREFIX = "ei";
	public static final String EAGLE_I_URI = OBO_URI;

	public static final String OBI_PREFIX = "obi";
	public static final String OBI_URI = OBO_URI;

	public static final String EAGLE_I_DT_PREFIX = "ei-dt";
	public static final String EAGLE_I_DT_URI = "http://eagle-i.org/ont/datatools/1.0/";

	public static final String EAGLE_I_REPO_PREFIX = "repo";
	public static final String EAGLE_I_REPO_URI = "http://eagle-i.org/ont/repo/1.0/";

	public static final String EAGLE_I_APP_PREFIX = "ei-app";
	public static final String EAGLE_I_APP_URI = "http://eagle-i.org/ont/data/";

	public static final String DC_PREFIX = "dcterms";
	public static final String DC_URI = "http://purl.org/dc/terms/";

	public static final String RDFS_PREFIX = "rdfs";
	public static final String RDFS_URI = "http://www.w3.org/2000/01/rdf-schema#";

	public static final String RDF_PREFIX = "rdf";
	public static final String RDF_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

	public static final String RO_PREFIX = "ro";
	public static final String RO_URI = "http://www.obofoundry.org/ro/ro.owl#";

	public static final String IAO_PREFIX = "iao";
	public static final String IAO_URI = OBO_URI;

	public static final String FOAF_PREFIX = "foaf";
	public static final String FOAF_URI = "http://xmlns.com/foaf/0.1/";

	public static final String SWO_PREFIX = "swo";
	public static final String SWO_URI = "http://www.ebi.ac.uk/efo/swo/";

	public static final String SO_PREFIX = "so";
	public static final String SO_URI = "http://purl.org/obo/owl/SO#";

	
	public static final String TERM_NOT_FOUND_URI="http://eagle-i.org/ont/datatools/1.0/temp_term_not_found";

	public static final Map<String, String> nameSpaceMap = new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;

		{
			put( EAGLE_I_PREFIX, EAGLE_I_URI );
			put( EAGLE_I_DT_PREFIX, EAGLE_I_DT_URI );
			put( EAGLE_I_APP_PREFIX, EAGLE_I_APP_URI );
			put( RDFS_PREFIX, RDFS_URI );
			put( RDF_PREFIX, RDF_URI );
			put( DC_PREFIX, DC_URI );
			put( IAO_PREFIX, IAO_URI );
			put( RO_PREFIX, RO_URI );
			put( FOAF_PREFIX, FOAF_URI );
			put( SWO_PREFIX, SWO_URI );
			put( SO_PREFIX, SO_URI );
			// put(OBI_PREFIX, OBI_URI);
		}
	};

	// Data URI will be: "http://" + site + EAGLE_I_DATA_URI_FRAGMENT
	public static final String EAGLE_I_DATA_URI_FRAGMENT = ".data.eagle-i.org/i/";
	// TO hold discovered data that doesn't fit anywhere
	public static final String NON_ONTOLOGY_URI = "http://eagle-i.org/ont/unknown/";
	
	// Is stub property from the datatools.ext model
	public static final String IS_STUB_URI = "http://eagle-i.org/ont/datatools/1.0/is_stub";

	// FIXME Some ranges - while we figure out how to get them from ontology
	public static final String EI_LAB = "http://purl.obolibrary.org/obo/ERO_0000001";
	public static final String FOAF_PERSON = "http://xmlns.com/foaf/0.1/Person";
	public static final String EI_UNIVERSITY = "http://purl.obolibrary.org/obo/ERO_0000065";
	public static final String OBI_ORGANIZATION = "http://purl.obolibrary.org/obo/OBI_0000245";
	public static final String EI_INSTRUMENT = "http://purl.obolibrary.org/obo/ERO_0000004";
	public static final String EI_SOFTWARE = "http://purl.obolibrary.org/obo/ERO_0000071";
	public static final String SW_DATA = "http://www.ebi.ac.uk/efo/swo/SWO_0000515";
	public static final String OBI_OBJECTIVE = "http://purl.obolibrary.org/obo/OBI_0200166";
	public static final String DT_TERM_REQUEST = "http://eagle-i.org/ont/datatools/1.0/TermRequest";
	public static final String DT_TOP_TERM_REQUEST = "http://eagle-i.org/ont/datatools/1.0/TopLevelTermRequest";

	// Workflow property URIs & labels
	public static final String WORKFLOW_OWNER = "http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner";
	public static final String WORKFLOW_STATUS = "http://eagle-i.org/ont/repo/1.0/hasWorkflowState";
	public static final String CREATOR = "http://purl.org/dc/terms/creator";
	public static final String WORKFLOW_OWNER_LABEL = "hasWorkflowOwner";
	public static final String WORKFLOW_STATUS_LABEL = "hasWorkflowState";
	public static final String CREATOR_LABEL = "creator";

	public static final String DRAFT_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Draft";
	public static final String CURATION_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Curation";
	public static final String PUBLISHED_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Published";
	public static final String WITHDRAWN_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn";
	// Put URIs here because GWT has trouble with DatatoolsConstants, and we keep using them.
	public static final String CURATION_STATE_LABEL = "In curation";
	public static final String PUBLISH_STATE_LABEL = "Published";
	public static final String DRAFT_STATE_LABEL = "Draft";
	public static final String WITHDRAW_STATE_LABEL = "Withdrawn";
	public static final String WITHDRAW_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn";
	public static final String PUBLISH_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Published";
	public static final String CURATION_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Curation";
	public static final String DRAFT_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Draft";
	// State entities
	public static final EIEntity CURATION_ENTITY = EIEntity.create( CURATION_URI, CURATION_STATE_LABEL );
	public static final EIEntity PUBLISH_ENTITY = EIEntity.create( PUBLISH_URI, PUBLISH_STATE_LABEL );
	public static final EIEntity DRAFT_ENTITY = EIEntity.create( DRAFT_URI, DRAFT_STATE_LABEL );
	public static final EIEntity WITHDRAW_ENTITY = EIEntity.create( WITHDRAW_URI, WITHDRAW_STATE_LABEL );


	public static EIEntity getStatusEntity(final EIURI statusUri) {
		if ( statusUri == null ) {
			return EIEntity.NULL_ENTITY;
		}
		if ( DRAFT_URI.equals( statusUri.toString() ) ) {
			return DRAFT_ENTITY;
		} else if ( CURATION_URI.equals( statusUri.toString() ) ) {
			return CURATION_ENTITY;
		} else if ( PUBLISH_URI.equals( statusUri.toString() ) ) {
			return PUBLISH_ENTITY;
		} else if ( WITHDRAW_URI.equals( statusUri.toString() ) ) {
			return WITHDRAW_ENTITY;
		}
		return EIEntity.NULL_ENTITY;
	}

	public static final String DEFAULT_DATATOOLS_CONFIG = "datatools.prop";
	public static final String DATATOOLS_CONFIG = "datatools.config.file";

	// Property associating resources to labs
	public static final String labAnnotation = "http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab"; 
}
