#!/bin/bash
#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

# de-etl a previous ETL'd file

# Fail on subprocess failures
set -o errexit
        
usage="usage: $0  -f fileName -r targetRepoUrl -c username:password"

#TODO move to getopts (see data-migration.sh)
while echo "$1" | grep -q "^-"; do
    case "$1" in
        -f)
            shift;
            filename="$1" ;;
        -r)
            shift;
            repo="$1" ;;
        -c)
            shift;
            creds="$1" ;;
        -*)
              echo "Unknown option $1"
              echo -e $usage
              exit 1;;
    esac
    shift
done

if [ ! -n "${filename}" ]||[ ! -n "${repo}" ]||[ ! -n "${creds}" ];  then
    echo -e $usage
    exit 1
fi

executableDir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
etljar="$(cd "$executableDir/lib" && ls |grep etl)"
cp="$executableDir:$executableDir/lib/$etljar"

echo "Java info: "
which java
java -version 2>&1
echo ""
echo "using classpath : $cp"
echo ""

# execute the deETLer
# give it a lot of memory to support ontology loading

java  -Xmx2G -cp ${cp} \
org.eaglei.datatools.etl.toolkit.command.DeETLer \
-tr ${repo} \
-tc ${creds} \
-f ${filename} \

exitCode=$?
if [ $exitCode -gt 0 ] ; then
    echo "non-zero exit code $exitCode - exiting"
    exit $exitCode
else
    echo "=== deETL Complete ==="
fi









