package org.eaglei.datatools.provider;

import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;


public interface RepositoryProvider  {

    /*
     * EIInstance functionality
     */

	//FIXME these granular, query-oriented methods should be moved elsewhere
    @Deprecated
    public List<EIInstance> getResourcesOfClass(String session, String rnav, EIURI classUri)throws Exception;
    @Deprecated
    public List<EIInstance> getAllResources(String session, String rnav) throws Exception; 
    
    //Should favor EIQuery over the specific methods
    public List<EIInstance> EIQuery(String session, String sparql) throws Exception;
    
    // CRUD, etc
    public List<EIURI> getNewInstanceID(String session, int count) throws Exception;
    public EIInstance getEmptyEIInstance(String session, EIURI classUri, EIEntity instanceEntity) throws Exception; 
    public EIInstance getEmptyEIInstance(String session, EIURI classUri) throws Exception;
    public EIInstance getInstance(String session, EIURI instanceID) throws Exception;
    public String updateInstance(String session, EIInstance instance, String token) throws Exception ;;
    public void createInstance(String session, EIInstance instance) throws Exception ;;
    public EIInstance deepCopy(String session, EIURI originalUri) throws Exception ;
  
    public void deleteInstance(String session, EIInstance instance) throws Exception ;;

    public String retrieveLabel(String session, EIURI uri) throws Exception;   
    public Map<EIEntity,String> retrieveLabels(String session, List<EIEntity> entities) throws Exception;
    public Map<EIURI, String> retrieveUriLabels(String session, List<EIURI> uris) throws Exception;

    /*
     * Bulk upload
     */
    
    public void uploadInstances(String session, String rdf) throws Exception;
    
    /*
     *  free from SPARQL query to this provider
     */
    
    
    public String query(String session, String sparql) throws Exception;
    
    /*
    * login/logout etc
    */
    
   public String[] login(String user, String password) throws Exception;    
   public void logout(String session) throws Exception;
   public String[] whoami(String session) throws Exception;
   public boolean isOnline();
   
   /*
    * workflow fake REST API
    */
   
   //public String getWorflowState(String session, String uri) throws Exception; // Maybe?  Return type?
   public String promote(String session, String uri, String newState) throws Exception; // or is it String[]?
   public String claim(String session, String uri, String claimant) throws Exception; // or is it String[]?
   public List<EIInstance> getInstancesForLab(String session, String rnav, String labURI) throws Exception;
   public List<EIInstance> getFilterQuery(final String session, final String user, final EIURI classUri, final EIURI state, final EIURI lab) throws Exception;
   public String[] getWFStates(String session, String user) throws Exception;

}
