/**
 * 
 */
package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public interface DataManagmentRemoteServiceAsync {

	
	//TODO I think I prefer to have dedicated methods for object==literal and object==resource; but this will lead to too many methods due to the different combinations. 
	//think about it (dbw)
	
	public void getResourcesToRepair(Session session,EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral, AsyncCallback<List<BulkCurationTriple>> callback);
	
	public void getResourcesToRepairByRegex(Session session,EIURI typeURI, EIURI predicateURI, String regex, AsyncCallback<List<BulkCurationTriple>> callback) throws ClientSideRepositoryException;

	public void replaceObject(Session session,EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void replacePredicate(Session session,EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void replaceObjectAndPredicate(Session session,EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString,  Boolean isNewObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void deleteTriple(Session session,EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void replaceObjectByRegex(Session session,EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;
	
	public void addTriple(Session session, EIURI typeURI, EIURI selectPredicateURI, EIURI newPredicateURI, String selectObjectString, Boolean isSelectObjectLiteral, String newObjectString,  Boolean isNewObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;
	

}
