/**
 * 
 */
package org.eaglei.datatools.client.rpc;

import com.google.gwt.core.client.GWT;

/**
 * @author "Sravan Cheriyala" Started Mar 21, 2011
 */
public class DataManagmentServiceFactory {

	private static DataManagmentServiceFactory dataManagmentManager;
	private DataManagmentRemoteServiceAsync dataManagmentService;
	private DataManagmentRemoteAuthServiceAsync dataManagementAuthService;
	private RepositorySecurityServiceAsync repoSecutiryService;

	private DataManagmentServiceFactory() {
		dataManagmentService = GWT.create( DataManagmentRemoteService.class );
		dataManagementAuthService = GWT.create( DataManagmentRemoteAuthService.class );
		repoSecutiryService = GWT.create( RepositorySecurityService.class );

	}

	public static DataManagmentServiceFactory getInstance() {
		if ( dataManagmentManager == null ) {
			dataManagmentManager = new DataManagmentServiceFactory();
			return dataManagmentManager;
		} else {
			return dataManagmentManager;
		}
	}

	public DataManagmentRemoteServiceAsync getDataManagmentService() {
		return dataManagmentService;
	}

	public DataManagmentRemoteAuthServiceAsync getDataManagmentAuthService() {
		return dataManagementAuthService;
	}

	public RepositorySecurityServiceAsync getRepositorySecutiryService() {
		return repoSecutiryService;
	}
}
