package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The GWT client side stub for the RPC service to the repository
 */
@RemoteServiceRelativePath("../datatools/repository")
public interface RepositoryToolsModelService extends RepositoryProvider, RemoteService {

	public EIClass getRootSuperclassForInstanceUri(Session session, EIURI instanceUri) throws ClientSideRepositoryException;

	public List<EIClass> getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri) throws ClientSideRepositoryException;

	public EIClass getRootSuperClass(EIClass eclass) throws ClientSideRepositoryException;

	public List<EIProperty> getAllEquivalentClasses(List<EIProperty> propertiesToPopulate);
		
	public boolean isModelClassURI(EIURI uri);
}
