package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.InstancePanel;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;

/**
 * Creates a Form Panel. This is a common class for Labs & Resources
 * 
 * @author pp101
 * 
 */
public class FormsPanelFactory {
	
	private static final GWTLogger log = GWTLogger.getLogger("FormsPanelFactory");
	
	@Deprecated
	private FormsPanelFactory() {

	}

	/**
	 * Generates a new form based on the URI passed.
	 * 
	 * @return
	 */
	public static FlowPanel generateNewForm(final EIEntity typeEntity) {
		return generateNewForm( typeEntity.getURI(), getNewFormRedisplay() );
	}

	public static FlowPanel generateNewForm(final EIURI typeUri, final EditFormRedisplay redisplay) {
		final FlowPanel vp = new FlowPanel();

		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance( typeUri, new RootAsyncCallback<EIInstance>() {
			@Override
			public void onSuccess(final EIInstance newInstance) {
				InstancePanel formsPanel;
				formsPanel = EditFormsPanel.createNewForm( newInstance, redisplay );
				vp.add( formsPanel );
			}
		} );
		return vp;
	}

	/**
	 * This method creates a form to edit. The values of fields will be prepopulated.
	 * 
	 * @param eiuri
	 * @return
	 */
	public static InstancePanel generateEditForm(final EIInstance instance) {
		return generateEditContents( instance );
	}

	public static FlowPanel generateDuplicateForm(final EIInstance instance) {
		final FlowPanel vp = new FlowPanel();
		vp.setStyleName( "formPanel" );
		final InstancePanel formsPanel = EditFormsPanel.createNewForm( instance, getNewFormRedisplay() );
		vp.add( formsPanel );
		return vp;
	} 

	public static FlowPanel generateViewForm(final EIURI uri) {
		final FlowPanel vp = new FlowPanel();
		vp.setStyleName( "formPanel" );
		
			ClientRepositoryToolsManager.INSTANCE.getInstance( uri, new RootAsyncCallback<EIInstance>() {
		
				@Override
				public void onSuccess(final EIInstance instance) {
					vp.add( generateViewForm( instance ) );
				}
			} );
		return vp;
	}

	@Deprecated
	public static FlowPanel generateEditForm(final String eiuri) {
		return generateEditForm( EIURI.create( eiuri ) );
	}

	public static FlowPanel generateEditForm(final EIURI uri) {
		final FlowPanel vp = new FlowPanel();
		vp.setStyleName( "formPanel" );

			ClientRepositoryToolsManager.INSTANCE.getInstance( uri, new RootAsyncCallback<EIInstance>() {
				@Override
				public void onSuccess(final EIInstance instance) {
					vp.add( generateEditContents( instance ) );
				}

			} );
		return vp;
	}

	private static InstancePanel generateEditContents(final EIInstance instance) {
		final InstancePanel formsPanel = EditFormsPanel.createEditForm( instance, getEditFormRedisplay() );
		return formsPanel;
	}

	/**
	 * This method creates a form in 'view' mode. The fields are not editable
	 * 
	 * @param eiuri
	 * @return
	 */
	public static FlowPanel generateViewForm(final EIInstance instance) {
		final FlowPanel vp = new FlowPanel();
		vp.setStyleName( "formPanel" );
		final InstancePanel formsPanel = new ViewFormsPanel( instance, getViewFormRedisplay() );
		vp.add( formsPanel );

		//final DataToolsBasicInstancePanel searchPanel = new SearchInstancePanel( instance );
		//vp.add(searchPanel);
		
		return vp;
	}

	private static void handleLoginRequired() {
		Window.alert( UIMessages.PLEASE_LOGIN );
	}

	protected static EditFormRedisplay getEditFormRedisplay() {
		return new EditFormRedisplay() {

			@Override
			public void drawAfterSave(final EIInstance instance) {
				// TODO: need a way to show a message!
				ApplicationState.getInstance().updateResourceProviderCache();
				
				EIEntity providerEntity = ResourceProvider.getProperResourceProviderEntity( instance );
				
				ApplicationState.getInstance().updateApplicationState( Mode.view, instance.getEntity(), instance.getInstanceType(), providerEntity );
			}

			@Override
			public void drawAfterPromote(final EIInstance instance) {
				AbstractEntryPoint.clearDataPanel(); // TODO: I don't like this here At
				// All!
					ClientRepositoryToolsManager.INSTANCE.getInstance( instance.getInstanceURI(), new RootAsyncCallback<EIInstance>() {
						@Override
						public void onSuccess(final EIInstance fetchedInstance) {
							generateEditForm( fetchedInstance );
						}

					} );
			}

			@Override
			public void drawAfterCancel(final EIInstance instance) {
				AbstractEntryPoint.clearDataPanel(); // TODO: I don't like this here At All!
					ClientRepositoryToolsManager.INSTANCE.getInstance( instance.getInstanceURI(), new RootAsyncCallback<EIInstance>() {
						@Override
						public void onSuccess(final EIInstance fetchedInstance) {
							viewAfterUpdate( fetchedInstance );
						}


						@Override
						public void onFailure(Throwable caught) {
							super.onFailure( caught );
							viewAfterUpdate( instance ); // TODO: correct?
						}
					} );

			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
				copyResource( instance.getInstanceURI() );
			}
		};
	}

	protected static ViewFormRedisplay getViewFormRedisplay() {
		return new ViewFormRedisplay() {

			@Override
			public void drawAfterPromote(final EIInstance instance) {
				AbstractEntryPoint.clearDataPanel(); // TODO: I don't like this here At
				// All!
					ClientRepositoryToolsManager.INSTANCE.getInstance( instance.getInstanceURI(), new RootAsyncCallback<EIInstance>() {
						@Override
						public void onSuccess(final EIInstance fetchedInstance) {
							AbstractEntryPoint.showData( generateViewForm( fetchedInstance ) ); // TODO: any way to NOT do the showData part?
						}

					} );
			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
				copyResource( instance.getInstanceURI() );
			}

			@Override
			public void drawEdit(final EIInstance instance) {
				AbstractEntryPoint.clearDataPanel(); // TODO: I don't like this here At
				// All!
				AbstractEntryPoint.showData( generateEditForm( instance ) );
			}
		};
	}

	public static void copyResource(final EIURI instanceId) {
		ClientRepositoryToolsManager.INSTANCE.deepCopyInstance( instanceId, new RootAsyncCallback<EIInstance>() {

			@Override
			public void onSuccess(final EIInstance eiInstance) {
				ApplicationState.getInstance().updateApplicationState( Mode.duplicate, eiInstance.getEntity(), eiInstance.getInstanceType(), ResourceProvider.getProperResourceProviderEntity( eiInstance ) );
				AbstractEntryPoint.showData( generateDuplicateForm( eiInstance ) );
				// Note: app state is set in a way that does NOT trigger a re-draw.  NOBODY else should use Mode.duplicate, or respond to it
			}
		} );
	}

	protected static EditFormRedisplay getNewFormRedisplay() {
		return new EditFormRedisplay() {

			@Override
			public void drawAfterSave(final EIInstance instance) {
				
				if ( ResourceProvider.isResourceProviderType( instance.getInstanceType() ) ) {
					log.debug( "updating resource provider cache" );
					ApplicationState.getInstance().updateResourceProviderCache();
					
				}
				
				EIEntity providerEntity = ResourceProvider.getProperResourceProviderEntity( instance );
				ApplicationState.getInstance().updateApplicationState( Mode.view, instance.getEntity(), instance.getInstanceType(), providerEntity );
				
			}

			@Override
			public void drawAfterPromote(final EIInstance instance) {
				Window.alert( "Cannot promote an unsaved new instance" );
			}

			@Override
			public void drawAfterCancel(final EIInstance instance) {
				Window.alert( "shouldn't get here (I think)" );
			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
				copyResource( instance.getInstanceURI() );
			}
		};
	}

	public static String getWFStateString(final EIInstance instance) {
		return instance.getWFState() == null ? "" : instance.getWFState().toString(); // TODO: make sure we need WFState() not
		// WFState().getURI()
	}

	public static void viewAfterSave(final boolean showSuccessMsg, final EIInstance instance) {
		AbstractEntryPoint.clearDataPanel(); // TODO: not here!
		if ( showSuccessMsg ) {
			final HTML msg = new HTML( "<font color='green'>" + UIMessages.SAVE_SUCCESS + "</font>" );
			AbstractEntryPoint.showData( msg );
		}

		ApplicationState.getInstance().updateApplicationState( Mode.view, instance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getResourceProviderEntity() );
	}

	public static void viewAfterUpdate(final EIInstance fetchedInstance) {
		ApplicationState.getInstance().updateApplicationState( Mode.view, fetchedInstance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getResourceProviderEntity() );
	}
}
