package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;

public abstract class EditWidget extends Composite {

	protected FlowPanel widgetPanel;
	protected EIInstance eiInstance;
	protected EIEntity propertyEntity;
	protected String propertyDefinition;
	protected boolean isRequired;
	protected String oldValue;
	protected boolean shouldShowLabel;
	protected Label label;
	protected final String name;

	private static GWTLogger log = GWTLogger.getLogger( "EditWidget" );

	EditWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired) {

		widgetPanel = new FlowPanel();
		widgetPanel.setStyleName("formPanelSubRowItem");
		name = propertyEntity.getURI().toString();
		this.eiInstance = eiInstance;
		this.propertyEntity = propertyEntity;
		this.propertyDefinition = propertyDefinition;
		this.isRequired = isRequired;
		label = InstanceWidgetUtils.createLabel( propertyEntity, propertyDefinition, isRequired );
		log.debug( "label: " + propertyEntity.getLabel() + "; required? " + isRequired + "; final label: " + label.getText() );
		widgetPanel.add( label );
		initWidget( widgetPanel );

	}

	protected void setLabelContents(final String newContents) {
		label.setText( newContents );
	}

	protected void updateOldValue(final String oldValue) {
		this.oldValue = oldValue;
	}

	protected void updateOldValue(final EIURI oldValue) {
		this.oldValue = oldValue.toString();
	}

	protected abstract void removeValue();

	public abstract EditWidget duplicateBlank();

	protected EIURI getOldEIURIValue() {
		return EIURI.create( oldValue );
	}

	protected String getOldStringValue() {
		return oldValue;
	}

	protected boolean hasOldValue() {
		return oldValue != null && !oldValue.equals( EIEntity.NULL_ENTITY.getURI().toString() ) && !"".equals( oldValue );
	}

	public boolean shouldShowLabel() {
		return shouldShowLabel;
	}

	protected String getLabel() {
		return propertyEntity.getLabel() + (isRequired ? "*" : "");
	}

	public void setShouldShowLabel(final boolean shouldShowLabel) {
		this.shouldShowLabel = shouldShowLabel;
		if ( !shouldShowLabel ) {
			setLabelContents( "" );
		} else {
			setLabelContents( getLabel() );
		}
	}

	public String getName() {
		return name;
	}
	
}
