package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;


import com.google.gwt.user.client.Window;

public class TypeWidget extends TermWidget {

	private final TypeChangeHandler typeChangeHandler;
	private final EIClass originalSuperclass;

	public interface TypeChangeHandler {
		public void onTypeChange();
	}

	//FIXME find out why the second parameter is null when this is called
	public TypeWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final EIClass range, final EIClass selectedClass, final TypeChangeHandler typeChangeHandler) {
		super( eiInstance, propertyEntity, "", true, range, selectedClass, true );
		this.typeChangeHandler = typeChangeHandler;
		originalSuperclass = range;
		setShouldShowLabel( true );
	}

	@Override
	protected void makeSelectionHandler(final SharedClassChooser<OntologyDropdown> classChooser) {
		classChooser.addSelectionListener( new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				// EIEntity entityToLoad = selectedEntity;
				if ( selectedEntity.equals( EIEntity.NULL_ENTITY ) ) {
					eiInstance.setInstanceType( originalSuperclass.getEntity() );
					// entityToLoad = originalSuperclass.getEntity();
					eiInstance.setInstanceClass( originalSuperclass );
					typeChangeHandler.onTypeChange();
				} else {
					// eiInstance.setInstanceType(selectedEntity);
					// }
					// TODO I think class chooser could be modified to return an EIClass
					ClientModelManager.INSTANCE.getClass( selectedEntity.getURI(), new ClassCallback() {

						@Override
						public void onSuccess(final EIClass result) {
							if ( result.isInferred() ) {
								eiInstance.setInstanceType( originalSuperclass.getEntity() );
								// entityToLoad = originalSuperclass.getEntity();
								eiInstance.setInstanceClass( originalSuperclass );
								Window.alert( UIMessages.NO_INSTANCES_FOR_INFERRED );
								typeChangeHandler.onTypeChange();
							} else {
								eiInstance.setInstanceType( result.getEntity() );
								eiInstance.setInstanceClass( result );
								typeChangeHandler.onTypeChange();
							}
						}
					} );

				}
			}
		} );
	}

	// Type is required
	@Override
	protected String getLabel() {
		String labelPrefix = originalSuperclass.getEntity().getLabel();
		return InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel(), true );
	}

	@Override
	protected void removeValue() {
		// Deliberate no-op; should we show an alert?
	}

	@Override
	public EditWidget duplicateBlank() {
		return null;
		// Deliberate no-op; should we show an alert?
	}
	
	@Override
	protected void addTermRequestWidget() {
		if(!eiInstance.isStub() && !eiInstance.isEmbeddedInstance()) {
			super.addTermRequestWidget();
		}
		// else do nothing. We do not want to add the Term Request widget in case of StubWidget.
	}
}
