/**
 * 
 */
package org.eaglei.datatools.server;

import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.RepositorySecurityService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.jena.FooRepositorySecurityProvider;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;
import org.eaglei.services.repository.RepositoryProviderException.RepositoryProviderExceptionType;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public abstract class AbstractRemoteServiceServlet extends RemoteServiceServlet implements RepositorySecurityService {

	private static final long serialVersionUID = 1L;
	private static final Log log = LogFactory.getLog( AbstractRemoteServiceServlet.class );
	protected RepositoryProvider repoProvider = null;
	protected FooRepositorySecurityProvider securityProvider;
	protected SecurityProvider generalSecurityProvider;
	protected InstitutionRegistry	institutionRegistry;
	protected EIOntModel ontModel;
	protected static ServletContext ctx;

	@Override
	// TODO clean this up - no need to distinguish between createProvider and loadDwefaults
	public void init() {
		log.info( "initializing abstract remote service servlet" );
		ctx = getServletContext();
		// FooRepositorySecurityProvider.setServletContext( ctx );
		initializeSingletons();
		log.info( "init succesful" );

	}

	/*
	 * @Override protected void onBeforeRequestDeserialized(String serializedRequest) { // TODO Auto-generated method stub super.onBeforeRequestDeserialized(serializedRequest); }
	 */
	protected void initializeSingletons() {
		final WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext( getServletContext() );
		doDependencyInjection( ctx );
	}

	/*
	 * Allow test subclasses to override servlet init and invoke this with their own ApplicationContext.
	 */
	protected void doDependencyInjection(final ApplicationContext springAppContext) {
		ontModel = springAppContext.getBean( EIOntModel.class );
		generalSecurityProvider = springAppContext.getBean( SecurityProvider.class );
		repoProvider = new RESTRepositoryProvider( ontModel, generalSecurityProvider );
		// FIXME figure out the relationship between RESTRepoProvider and securityProvider
		securityProvider = ( (RESTRepositoryProvider)repoProvider ).getDatatoolsSecurityProvider();
		institutionRegistry=springAppContext.getBean(InstitutionRegistry.class);
	}

	public void logout(final Session session) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			securityProvider.logout( session );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	protected void handleNullSession(final Session session) throws ClientSideRepositoryException {
		if ( !isValid( session ) ) {
			throw new ClientSideRepositoryException( RepositoryProviderExceptionType.INVALID_SESSION );
		}
	}

	protected boolean isValid(final Session session) {
		return session != null && session.getSessionId() != null;

	}

	public User login(final String user, final String password) throws ClientSideRepositoryException {
		try {
			User userObj = securityProvider.login( user, password );
			HttpSession httpSession = this.getThreadLocalRequest().getSession();
			httpSession.setAttribute( "user", userObj );
			return userObj;
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	public User whoami(final Session session) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return securityProvider.whoami( session );
		} catch (final RepositoryProviderException e) {
			log.error( "whoami exception " + e );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public boolean isOnline() {
		return securityProvider.isOnline();
	}

	@Override
	public List<Workspace> getWorkspaces(final Session session) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return securityProvider.getWorkspaces( session );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}
	
	@Override
	public List<WorkFlowTransition> listWorkFlowTransitions(final Session session, final EIEntity workspaceEntity) throws ClientSideRepositoryException {
		try {
			return securityProvider.listWorkFlowTransitions( session, workspaceEntity );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

}
