package org.eaglei.datatools.client.ui;

import static org.eaglei.datatools.client.WorkFlowConstants.WORKFLOW_ENTITY_LIST;

import java.util.List;

import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.widgets.OntologyDropdown;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.suggest.client.SharedClassChooser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;

public class FilterPanel extends Composite {

	interface Binder extends UiBinder<Widget, FilterPanel> {
	}

	// FIXME these names are very confusing
	// e.g. type means topLevelType
	private static final Binder binder = GWT.create( Binder.class );
	@UiField
	protected FlowPanel subTypeFilter;
	@UiField
	protected Label subTypeLabel;
	@UiField
	protected ListBox statusFilter;
	@UiField
	protected ListBox resourceTypeFilter;
	@UiField
	protected ListBox providerFilter;
	@UiField
	protected Label statusLabel;
	@UiField
	protected Label providerLabel;
	@UiField
	protected Label resourceTypeLabel;
	@UiField
	protected Label filterLabel;
	@UiField
	protected Label totalResources;
	@UiField
	protected RadioButton ownedByMe;
	@UiField
	protected RadioButton all;
	@UiField
	protected Button goButton;
	SharedClassChooser<OntologyDropdown> classChooser;
	private boolean isTopLevel = false;
	
	private static final GWTLogger log = GWTLogger.getLogger("FilterPanel");

	protected FilterPanel() {
	}

	public FilterPanel(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterProviderEntity) {
		init( filterTypeEntity, filterWorkflowEntity, filterProviderEntity );
		initOwnerFilter( filterTypeEntity, filterWorkflowEntity, filterProviderEntity, false );
	}

	public FilterPanel(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterProviderEntity, final boolean strictFilterByOwner) {
		init( filterTypeEntity, filterWorkflowEntity, filterProviderEntity );
		initOwnerFilter( filterTypeEntity, filterWorkflowEntity, filterProviderEntity, strictFilterByOwner );
	}

	private void init(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterProviderEntity) {
		initWidget( binder.createAndBindUi( this ) );
		filterLabel.setVisible( true );
		if ( filterTypeEntity != null && !filterTypeEntity.equals( EIEntity.NULL_ENTITY ) ) {
			initSubTypeFilter( filterTypeEntity );
		} else {
			// TODO: remove instead of disable?
			isTopLevel = true;
			resourceTypeFilter.addItem( genericOption );
			subTypeFilter.setVisible( false );
			subTypeLabel.setVisible( false );
			disable( resourceTypeFilter );

		}

		initWorkflowFilter( filterWorkflowEntity );
		initProviderFilter( filterProviderEntity );
		initGoButton();
	}

	public void disable() {
		disable( resourceTypeFilter );
		disable( providerFilter );
		disable( statusFilter );
		disable( goButton );
	}

	private void disable(final FocusWidget filter) {
		filter.setEnabled( false );
		filter.setStyleName( "btnDisabled" );
	}

	public void setCount(final int numberOfResources) {
		totalResources.setText( "(" + numberOfResources + ") instances found" );
		totalResources.setVisible( true );
	}

	private void initOwnerFilter(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterProviderEntity, final boolean strictFilterByOwner) {
		all.setValue( !strictFilterByOwner );
		ownedByMe.setValue( strictFilterByOwner );
		final ClickHandler clickHandler = new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().updateApplicationFilterState( filterTypeEntity, filterWorkflowEntity, filterProviderEntity, ownedByMe.getValue() );
			}
		};
		ownedByMe.addClickHandler( clickHandler );
		all.addClickHandler( clickHandler );
	}

	private void initGoButton() {
		goButton.setVisible( true );
		goButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent arg0) {
				EIEntity filterTypeEntity;
				if ( isTopLevel ) {
					filterTypeEntity = EIEntity.NULL_ENTITY;
				} else {
					// TODO revise appstate - does filter type need to be an entity? classchooser
					// only gives us the URI
					filterTypeEntity = classChooser.getSelectedEntity();
					if ( filterTypeEntity == null || filterTypeEntity == EIEntity.NULL_ENTITY ) {
						filterTypeEntity = ApplicationState.getInstance().hasType() ? ApplicationState.getInstance().getTypeEntity() : EIEntity.NULL_ENTITY;
					}
				}
				final String providerLabel = providerFilter.getItemText( providerFilter.getSelectedIndex() );
				EIEntity filterProviderEntity;
				if ( isGenericOption( providerLabel ) ) {
					filterProviderEntity = EIEntity.NULL_ENTITY;
				} else {
					final EIURI providerUri = EIURI.create( providerFilter.getValue( ( providerFilter.getSelectedIndex() ) ) );
					filterProviderEntity = EIEntity.create( providerUri, providerLabel );
				}
				final WorkFlowConstants wfc = new WorkFlowConstants();
				final String statusLabel = statusFilter.getItemText( statusFilter.getSelectedIndex() );
				final EIEntity filterWorkflowEntity = wfc.getStatusEntity( statusLabel );
				ApplicationState.getInstance().updateApplicationFilterState( filterTypeEntity, filterWorkflowEntity, filterProviderEntity, ownedByMe.getValue() );
			}
		} );
	}

	private final String genericOption = "All";

	private void initWorkflowFilter(final EIEntity filterWorkflowEntity) {
		statusFilter.setVisible( true );
		statusLabel.setVisible( true );
		statusFilter.addItem( genericOption );
		for (final EIEntity entity : WORKFLOW_ENTITY_LIST) {
			statusFilter.addItem( entity.getLabel(), entity.getURI().toString() );
			if ( entity.equals( filterWorkflowEntity ) ) {
				statusFilter.setSelectedIndex( statusFilter.getItemCount() - 1 );
			}
		}
	}

	private void initProviderFilter(final EIEntity filterProviderEntity) {
		providerFilter.setVisible( true );
		providerLabel.setVisible( true );
		if ( ApplicationState.getInstance().getTypeEntity().equals( ResourceProvider.BASE_RESOURCE_CONTAINER ) ) {
			providerFilter.addItem( genericOption );
			disable( providerFilter );
			return;
		}
		if ( !EIEntity.NULL_ENTITY.equals( filterProviderEntity ) ) {
			providerFilter.addItem( filterProviderEntity.getLabel(), filterProviderEntity.getURI().toString() );
		} else {
			providerFilter.addItem( genericOption );
		}
		if ( !EIEntity.NULL_ENTITY.equals( ApplicationState.getInstance().getResourceProviderEntity() ) ) {
			disable( providerFilter );
		} else {
			// Populate the list only when clicked
			providerFilter.addClickHandler( new ClickHandler() {

				@Override
				public void onClick(final ClickEvent arg0) {
					if ( providerFilter.getItemCount() == 1 ) { // Populate the list only
						// if it is not already
						// populated
						providerFilter.removeItem( providerFilter.getItemCount() - 1 );
						providerFilter.addItem( "List is loading...." );
						AuthSearchRequest request = new AuthSearchRequest();
							request.setType( ResourceProvider.BASE_RESOURCE_CONTAINER_URI );
							//FIXME enable
							request.setPaginated( false );
							//FIXME hook order by
							ClientRepositoryToolsManager.INSTANCE.listResources( request, SortByProperties.label, ApplicationState.getInstance().isAcending(), false, (ApplicationState.getInstance().getMode() == Mode.stubs), new RootAsyncCallback<List<EIInstanceMinimal>>() {

								@Override
								public void onSuccess(final List<EIInstanceMinimal> eiInstanceList) {
									providerFilter.removeItem( providerFilter.getItemCount() - 1 );
									providerFilter.addItem( genericOption );
									for (final EIInstanceMinimal instance : eiInstanceList) {
										providerFilter.addItem( instance.getInstanceLabel(), instance.getInstanceURI().toString() );
										if ( instance.getEntity().equals( filterProviderEntity ) ) {
											providerFilter.setSelectedIndex( providerFilter.getItemCount() - 1 );
										}
									}
								}

							} );
					}
				}
			} );
		}
	}

	private void initSubTypeFilter(final EIEntity filterTypeEntity) {
		resourceTypeFilter.setVisible( false );
		resourceTypeLabel.setVisible( false );
		classChooser = new SharedClassChooser<OntologyDropdown>( new OntologyDropdown() );
		classChooser.setTextBoxStyle( "formText" );
		classChooser.setVisible(false);
		filterLabel.setVisible(false);
		subTypeFilter.add( classChooser );
		subTypeLabel.setVisible( false );
		subTypeFilter.setVisible( true );
		// TODO think of storing the EIClass in AppState so we don't keep re-fetching it
		ClientModelManager.INSTANCE.getClass( ApplicationState.getInstance().getTypeUri(), new ClassCallback() {

			@Override
			public void onSuccess(final EIClass result) {
				filterLabel.setVisible(true);
				classChooser.setVisible(true);
				classChooser.setClass( result, false );
				classChooser.setSelectedEntity( filterTypeEntity );
			}
			
		} );
	}

	private boolean isGenericOption(final String label) {
		return genericOption.equals( label );
	}
}
