package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public  class LoginLogoutPanel extends Composite implements ClientRepositoryToolsManager.SessionListener {

	private static LoginLogoutPanelUiBinder uiBinder = GWT.create( LoginLogoutPanelUiBinder.class );

	private static GWTLogger log = GWTLogger.getLogger( "Datatools" );

	interface LoginLogoutPanelUiBinder extends UiBinder<Widget, LoginLogoutPanel> {
	}

	@UiField
	protected Label welcomeLabel;
	@UiField
	protected Anchor logoutAnchor;
	@UiField
	protected UListElement loginList;
	@UiField
	protected TextBox userTextBox;
	@UiField
	protected PasswordTextBox passTextBox;
	@UiField
	protected Button loginButton;

	private Element loginListParent;

	private boolean signedIn = false;

	public LoginLogoutPanel() {

		initWidget( uiBinder.createAndBindUi( this ) );
		loginListParent = loginList.getParentElement();

		welcomeLabel.setText( "Please login" );
		passTextBox.addKeyUpHandler( new KeyUpHandler() {

			@Override
			public void onKeyUp(final KeyUpEvent event) {
				if ( event.getNativeKeyCode() == KeyCodes.KEY_ENTER ) {
					performLogin();
				}
			}
		} );

		loginButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				performLogin();
			}
		} );

		if ( !signedIn ) {
			logoutAnchor.setVisible( false );
		}

		logoutAnchor.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				if ( signedIn ) {
					AbstractEntryPoint.setIsRefresh( false );
					performLogout();
				}
			}
		} );

		// when user does browser refresh then do the same what you would have done onLogIn
		if ( DatatoolsCookies.getSession() != null ) {
			onLogIn( DatatoolsCookies.getUserName(), DatatoolsCookies.getUserUri() );
		}

		ClientRepositoryToolsManager.INSTANCE.addSessionListener( this );
	}



	@Override
	public void onLogOut(boolean isSessionExpired) {
		welcomeLabel.setText( "Please login" );
		loginListParent.appendChild( loginList );
		loginList.getStyle().setVisibility( Style.Visibility.VISIBLE );
		signedIn = false;
		userTextBox.setText( "" );
		passTextBox.setText( "" );
		logoutAnchor.setVisible( false );

	}

	@Override
	public void onLogIn(final String username, final String userUri) {
		welcomeLabel.setText( "Welcome, " + username );
		logoutAnchor.setVisible( true );
		loginList.removeFromParent();
		signedIn = true;
	}

	
	public void performLogin() {
		log.debug( "triggered perfrom login" );

		final String user = userTextBox.getText();
		if ( user == null || user.trim().length() == 0 ) {
			Window.alert( UIMessages.NO_USER );
			return;
		}
		final String pass = passTextBox.getText();
		if ( pass == null || pass.trim().length() == 0 ) {
			Window.alert( UIMessages.NO_PASSWORD );
			return;
		}
		ClientRepositoryToolsManager.INSTANCE.logIn( user.trim(), pass.trim(), new RootAsyncCallback<User>() {

			@Override
			public void onSuccess(User userInfo) {
				AbstractEntryPoint.setUser( userInfo );
			}

		} );
	}

	public void performLogout() {
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

}
