package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ResourceProviderCache.ResourceProviderCacheListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;

public class Workbench extends Composite implements ResourceProviderCacheListener {

	private final ResourceProviderCache providerCache;

	private FlowPanel mainPanel;
	private FocusPanel addProviderPanel;
	private FocusPanel workWithProvidersPanel;
	private FocusPanel workWithResourcesPanel;
	private FocusPanel toDoListPanel;

	private Anchor chooseProviderLink;

	private FlowPanel chooseProviderPanel;
	private FlowPanel chooseProviderDropdownPanel;
	private ListBox providersList = new ListBox();

	private static final GWTLogger log = GWTLogger.getLogger( "Workbench" );

	public Workbench(ResourceProviderCache providerCache) {
		mainPanel = new FlowPanel();
		initWidget( mainPanel );
		mainPanel.setStyleName( "dtWorkBench" );

		this.providerCache = providerCache;
		providerCache.addProviderLoadListener( this );

		addProviderPanel = new FocusPanel();
		addProviderPanel.add( new HTML( DatatoolsUIConstants.CREATE_PROVIDER_BUTTON ) );
		addProviderPanel.setStyleName( "dtWbPanel" );
		addProviderPanel.addStyleName( "dtWbCreateLab" );
		chooseProviderLink = new Anchor( DatatoolsUIConstants.CHOOSE_PROVIDER_HEADER );
		workWithProvidersPanel = new FocusPanel();
		workWithProvidersPanel.add( new HTML( DatatoolsUIConstants.BROWSE_PROVIDERS_BUTTON ) );
		workWithProvidersPanel.setStyleName( "dtWbPanel" );
		workWithProvidersPanel.addStyleName( "dtWbAllLabs" );
		workWithResourcesPanel = new FocusPanel();
		workWithResourcesPanel.add( new HTML( DatatoolsUIConstants.BROWSE_RESOURCES_BUTTON ) );
		workWithResourcesPanel.setStyleName( "dtWbPanel" );
		workWithResourcesPanel.addStyleName( "dtWbResources" );
		toDoListPanel = new FocusPanel();
		toDoListPanel.add( new HTML( DatatoolsUIConstants.UNFINISHED_TASKS_BUTTON ) );
		toDoListPanel.setStyleName( "dtWbPanel" );
		toDoListPanel.addStyleName( "dtWbTodo" );

		chooseProviderPanel = new FlowPanel();
		chooseProviderDropdownPanel = new FlowPanel();
		if ( providerCache.isLoading() ) {
			providersList.addItem( DatatoolsUIConstants.LOADING_MESSAGE );
		} else {
			populateResourceProvidersList();
		}
		chooseProviderPanel.add( new HTML( DatatoolsUIConstants.WORK_WITH_PROVIDERS_HEADER ) );
		chooseProviderPanel.add( chooseProviderDropdownPanel );
		providersList.setStyleName( "dtWbCurrentLabSelect" );
		chooseProviderDropdownPanel.add( providersList );
		chooseProviderDropdownPanel.setStyleName( "dtWbCurrentLabsDropdown" );
		chooseProviderPanel.setStyleName( "dtWbPanel" );
		chooseProviderPanel.addStyleName( "dtWbCurrentLab" );

		mainPanel.add( chooseProviderPanel );
		mainPanel.add( addProviderPanel );

		mainPanel.add( workWithProvidersPanel );
		mainPanel.add( workWithResourcesPanel );
		mainPanel.add( toDoListPanel );

		addProviderPanel.addClickHandler( getAddProviderHandler() );
		chooseProviderLink.addClickHandler( getChooseProviderHandler() );
		workWithProvidersPanel.addClickHandler( getWorkWithProvidersHandler() );
		workWithResourcesPanel.addClickHandler( getPeopleAndResourcesHandler() );
		toDoListPanel.addClickHandler( getToDoListHandler() );

		// toDoLink = new HTML("My to-do list");
		// toDoLink.setStyleName(style)
	}

	private ClickHandler getWorkWithProvidersHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.providers, EIEntity.NULL_ENTITY, ResourceProvider.RESOURCE_PROVIDER_CLASS_GROUP_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private ClickHandler getChooseProviderHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if ( providerCache.isLoading() ) {
					Window.alert( "Resource contributing organizations are still loading. Please wait." );
				}
				chooseProviderPanel.setVisible( true );
			}
		};
	}

	private ClickHandler getPeopleAndResourcesHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.resources, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private ClickHandler getAddProviderHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.edit, EIEntity.NULL_ENTITY, ResourceProvider.BASE_RESOURCE_CONTAINER, EIEntity.NULL_ENTITY );
			}
		};
	}

	private ClickHandler getToDoListHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.stubs, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private void populateResourceProvidersList() {
		providersList.clear();

		providersList.addItem( DatatoolsUIConstants.CHOOSE_PROVIDER_DROP_DOWN );
		StringBuilder strBuild = new StringBuilder();
		for (final EIEntity provider : providerCache.getResourceProviderEntities()) {
			strBuild.append(provider.getLabel());
			strBuild.append(" <");
			strBuild.append(providerCache.getResourceProviderType(provider).getLabel());
			strBuild.append(">");
			providersList.addItem( strBuild.toString() , provider.getURI().toString() );
			strBuild.delete(0, strBuild.length());
		}

		providersList.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				EIURI selectedUri = EIURI.create( providersList.getValue( providersList.getSelectedIndex() ) );
				EIEntity selectedEntity = providerCache.getResourceProvider( selectedUri );
				if ( selectedEntity == null || selectedEntity.equals( EIEntity.NULL_ENTITY ) ) {
					return;
				}
				ApplicationState.getInstance().updateApplicationState( Mode.view, selectedEntity, ResourceProvider.BASE_RESOURCE_CONTAINER, selectedEntity );
			}
		} );

	}

	@Override
	public void onProvidersLoaded() {
		populateResourceProvidersList();
	}

	public void resetSelectedProvider() {
		providersList.setSelectedIndex( 0 );
	}

}
