package org.eaglei.datatools.client.ui.widgets;

import java.util.Iterator;
import java.util.List;

import org.eaglei.datatools.Workspace;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;

/**
 * WorkspaceChooserPopup is a Dialog box which enable user to choose the workspace out of all the workspaces he has access to , It will present user with radiobuttons list of workspace. You can get the selected workspace by call
 * getSelectedWorkspace() <b>This dialog will only showup when the user has access to more then one workspace.</b>
 * 
 * @author Sravan Cheriyala
 * 
 */
public class WorkspaceChooserPopup extends EIConfirmationPopup {

	private List<Workspace> workspaces;
	private Workspace selectedWorkspace;
	private final String HEADING = "Choose labs or organizations";

	public WorkspaceChooserPopup(final List<Workspace> workspaces) {
		if ( workspaces != null ) {
			final ScrollPanel scrollPanel = new ScrollPanel();
			this.workspaces = workspaces;
			scrollPanel.setHeight( "280px" );
			scrollPanel.setWidth( "1000px" );
			setHeight( "100%" );
			setWidth( "100%" );
			add( scrollPanel );
		}

	}

	public List<Workspace> getWorkspaces() {
		return workspaces;
	}

	public void setWorkspaces(final List<Workspace> workspaces) {
		this.workspaces = workspaces;
	}

	public Panel makeRadioButtonChoicesUI(final List<Workspace> workspaces) {
		final Iterator<Workspace> iter = workspaces.iterator();
		final FlexTable flexTable = new FlexTable();
		flexTable.setWidth( "100%" );
		final Label heading = new Label( HEADING );
		heading.setStyleName( "dataPanelLabel" );
		flexTable.setWidget( 0, 1, heading );
		int i = 1;
		while ( iter.hasNext() ) {
			final Workspace workspace = iter.next();
			final RadioButton radioButton = new RadioButton( "workspaces" );

			radioButton.addClickHandler( new ClickHandler() {

				@Override
				public void onClick(final ClickEvent event) {
					if ( radioButton.getValue() ) {
						selectedWorkspace = workspace;
					}
				}
			} );
			flexTable.setWidget( i, 0, radioButton );
			// TODO setwidth from css
			flexTable.getCellFormatter().setWidth( i, 0, "50px" );
			flexTable.setWidget( i, 1, new Label( workspace.getWorkspaceName() ) );
			i++;
		}
		return flexTable;
	}

	public Workspace getSelectedWorkspace() {
		return selectedWorkspace;
	}

	@Override
	public void show() {
		/*
		 * Only show popup if user has access to more than one workspace
		 */
		if ( workspaces != null && workspaces.size() > 1 ) {
			super.show();
		}
	}

}
