/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EIEmbeddedResourceEditWidget;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.datatools.client.ui.widgets.TypeWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.OntologyPropertiesRenderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class OntologyPropEditRenderer
extends OntologyPropertiesRenderer {
    protected final List<EIEntity> dataPropEntityList = new ArrayList<EIEntity>();
    protected final List<EIEntity> booleanPropEntityList = new ArrayList<EIEntity>();
    protected final List<EIEntity> objPropEntityList = new ArrayList<EIEntity>();
    protected final Map<EIEntity, List<EIClass>> objectPropertyRanges = new HashMap<EIEntity, List<EIClass>>();
    private final EIEntity providerEntity = ApplicationState.getInstance().getResourceProviderEntity();
    private static final GWTLogger log = GWTLogger.getLogger("OntologyPropEditRenderer");
    private final NewInnerInstanceListener listener;

    public OntologyPropEditRenderer(EIInstance eiInstance, FlowPanel ontologyPanel, NewInnerInstanceListener innerListener) {
        super(eiInstance, ontologyPanel);
        this.listener = innerListener;
    }

    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        if (propertyEntity.equals((Object)EagleIEntityConstants.RDFS_LABEL_ENTITY)) {
            FlowPanel temp = new FlowPanel();
            temp.setStyleName("formPanelRow");
            this.ontologyPanel.add((Widget)temp);
            temp.add((Widget)TextWidget.makeLabelTextWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValues.iterator().next()));
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.booleanPropEntityList.contains(propertyEntity)) {
                this.ontologyPanel.add((Widget)WidgetUtils.createRadioButon(this.eiInstance, propertyEntity, propertyDefinition, isRequired, null));
            } else {
                this.ontologyPanel.add((Widget)new EditWidgetCollection(this.eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, null)));
            }
        } else {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            for (String value : propertyValues) {
                if (this.booleanPropEntityList.contains(propertyEntity)) {
                    fields.addWithoutModifiers((Widget)WidgetUtils.createRadioButon(this.eiInstance, propertyEntity, propertyDefinition, isRequired, value));
                    continue;
                }
                fields.addWidget(TextWidget.makeDatatypeTextWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, value));
            }
            fields.setStyleName("required");
            this.ontologyPanel.add((Widget)fields);
        }
    }

    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (propertyEntity.equals((Object)EagleIEntityConstants.RDF_TYPE_ENTITY)) {
            this.drawTypeProperty();
        } else if (this.objectPropertyRanges.get(propertyEntity) != null && this.objectPropertyRanges.get(propertyEntity).size() > 0) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            this.ontologyPanel.add((Widget)fields);
            if (this.objectPropertyRanges.get(propertyEntity).size() == 1) {
                this.drawSingleObjectProperty(propertyEntity, propertyDefinition, isRequired, propertyValues, fields);
            } else {
                log.info(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : Integer.valueOf(propertyValues.size())) + "entries");
                if (propertyValues == null || propertyValues.size() == 0) {
                    this.createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, null, fields);
                } else {
                    for (EIEntity selectedEntity : propertyValues) {
                        this.createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, selectedEntity, fields);
                    }
                }
            }
        }
    }

    private void drawSingleObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues, EditWidgetCollection fields) {
        EIClass range = this.objectPropertyRanges.get(propertyEntity).iterator().next();
        if (this.hasResourceProviderUri() && this.isResourceProviderRelatedProperty(propertyEntity)) {
            log.info("making disabled widget for provider uri '" + this.providerEntity + "' property " + range.getEntity().getLabel());
            this.eiInstance.addObjectProperty(propertyEntity, this.providerEntity);
            this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, this.providerEntity, fields, true);
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.isResourceProviderRelatedProperty(propertyEntity)) {
                log.info("drawing widget for resource provider prop " + range.getEntity().getLabel() + " without treating it as resource provider");
            }
            this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, fields, false);
        } else {
            if (this.isResourceProviderRelatedProperty(propertyEntity)) {
                log.info("drawing multiple widgets for resource provider prop " + range.getEntity().getLabel() + " without treating it as resource provider");
            }
            for (EIEntity selectedEntity : propertyValues) {
                this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, false);
            }
        }
    }

    private boolean isDataModelCreateRange(EIClass range) {
        if (ApplicationState.getInstance().getResourceTypesForProvider() == null) {
            return false;
        }
        return ApplicationState.getInstance().getResourceTypesForProvider().contains(range);
    }

    protected boolean hasResourceProviderUri() {
        return this.providerEntity != null && this.providerEntity.getURI() != EIURI.NULL_EIURI && !this.providerEntity.getURI().toString().equals("");
    }

    private void drawTypeProperty() {
        FlowPanel temp = new FlowPanel();
        temp.setStyleName("formPanelRow");
        this.ontologyPanel.add((Widget)temp);
        TypeWidget typeWidget = new TypeWidget(this.eiInstance, EagleIEntityConstants.RDF_TYPE_ENTITY, this.eiInstance.getRootSuperType(), this.eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler(){

            @Override
            public void onTypeChange() {
                log.info("redrawing; type changed to " + OntologyPropEditRenderer.this.eiInstance.getInstanceClass());
                OntologyPropEditRenderer.this.ontologyPanel.clear();
                OntologyPropEditRenderer.this.eiClass = OntologyPropEditRenderer.this.eiInstance.getInstanceClass();
                OntologyPropEditRenderer.this.initializeProperties();
            }
        });
        temp.add((Widget)typeWidget);
    }

    private void createWidgetForMultiRanges(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIEntity selectedEntity, EditWidgetCollection fields) {
        log.info("making multi-range widget with " + this.objectPropertyRanges.get(propertyEntity).size() + " ranges");
        ObjectWidget widget = new ObjectWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, this.objectPropertyRanges.get(propertyEntity), this.providerEntity, selectedEntity, this.isResourceProviderRelatedProperty(propertyEntity), this.listener);
        fields.addWidget(widget, widget.isDisabled());
    }

    private void createWidgetForRange(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, EditWidgetCollection fields, boolean isProvider) {
        if (ApplicationState.getInstance().getEmbeddedClasses().contains(range)) {
            this.addEmbeddedInstanceWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true);
        } else if (range.isEagleIResource()) {
            boolean isProviderRelatedProperty = this.isResourceProviderRelatedProperty(propertyEntity);
            EIResourceListWidget resourceWidget = new EIResourceListWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, true, isProviderRelatedProperty, this.listener);
            fields.addWidget(resourceWidget, isProvider);
            if (isProvider) {
                resourceWidget.disableAsProviderProperty();
            }
        } else {
            WidgetUtils.addTermWidgetToPanel(this.eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true);
        }
    }

    private boolean isResourceProviderRelatedProperty(EIEntity propertyEntity) {
        if (((EIProperty)this.eiPropertiesEntityMap.get(propertyEntity)).getAnnotations() == null) {
            return false;
        }
        return ((EIProperty)this.eiPropertiesEntityMap.get(propertyEntity)).getAnnotations().contains("http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab");
    }

    private void addEmbeddedInstanceWidget(EIInstance outerInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, EditWidgetCollection fields, boolean showLabel) {
        EIInstance embeddedInstance = outerInstance.getEmbeddedInstance(selectedEntity);
        EIEmbeddedResourceEditWidget widget = new EIEmbeddedResourceEditWidget(outerInstance, embeddedInstance, range.getEntity(), propertyEntity, propertyDefinition, isRequired, showLabel, this.listener);
        fields.addWidget(widget);
    }

    protected void finishSetup() {
        this.dataPropEntityList.clear();
        this.objPropEntityList.clear();
        this.objectPropertyRanges.clear();
        this.booleanPropEntityList.clear();
        this.propertyInitializationCallback();
    }

    protected void addNameProperty(String labelPrefix) {
        EIEntity namePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel(), (boolean)true));
        this.drawDataProperty(namePropEntity, "", true, this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
    }

    protected void addTypeProperty(String labelPrefix) {
        EIEntity typePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel(), (boolean)true));
        this.drawObjectProperty(typePropEntity, "", true, this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
    }

    public void fetchConstants() {
        if (ApplicationState.getInstance().getEmbeddedClasses() == null) {
            ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class", new ClientModelManager.ClassesInGroupCallback(){

                public void onSuccess(List<EIClass> result) {
                    ApplicationState.getInstance().setEmbeddedClassList(result);
                    OntologyPropEditRenderer.this.finishSetup();
                }
            });
        } else {
            this.finishSetup();
        }
    }

    private void propertyInitializationCallback() {
        for (EIProperty property : this.eiProperties) {
            if (property instanceof EIDatatypeProperty) {
                this.dataPropEntityList.add(property.getEntity());
                if (!((EIDatatypeProperty)property).getTypeLabel().equals("boolean")) continue;
                this.booleanPropEntityList.add(property.getEntity());
                continue;
            }
            if (!(property instanceof EIObjectProperty) || EagleIEntityConstants.EI_ORGANIZATION_URI.equals((Object)this.eiInstance.getRootSuperType().getEntity().getURI()) && EagleIEntityConstants.HAS_MEMBERS_URI.equals((Object)property.getEntity().getURI())) continue;
            this.objPropEntityList.add(property.getEntity());
            List assertedRanges = ((EIObjectProperty)property).getRangeList();
            ArrayList<EIClass> rangesMinusDataModelCreate = new ArrayList<EIClass>();
            if (EagleIEntityConstants.EI_ORGANIZATION_URI.equals((Object)this.eiInstance.getRootSuperType().getEntity().getURI())) {
                for (EIClass range : assertedRanges) {
                    if (this.isDataModelCreateRange(range)) continue;
                    log.debug("Found range not annotated to DatatoolsCreate");
                    rangesMinusDataModelCreate.add(range);
                }
            } else {
                rangesMinusDataModelCreate.addAll(assertedRanges);
            }
            if (rangesMinusDataModelCreate.isEmpty()) continue;
            this.objectPropertyRanges.put(property.getEntity(), rangesMinusDataModelCreate);
        }
        super.finishSetup();
    }

    public Collection<EIEntity> getDataTypeEntities() {
        return this.dataPropEntityList;
    }

    public Collection<EIEntity> getObjectTypeEntities() {
        return this.objPropEntityList;
    }

    public void addFormTitle(String type) {
    }
}

