/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.widgets.EIEmbeddedResourceViewWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.OntologyPropertiesRenderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public class OntologyPropViewRenderer
extends OntologyPropertiesRenderer {
    public OntologyPropViewRenderer(EIInstance eiInstance, FlowPanel ontologyPanel) {
        super(eiInstance, ontologyPanel);
    }

    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.ontologyPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
    }

    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (this.eiInstance.isPropertyValueAnEmbeddedInstance(propertyEntity)) {
            for (EIEntity propertyValue : propertyValues) {
                if (propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) continue;
                EIEmbeddedResourceViewWidget embeddedWidget = new EIEmbeddedResourceViewWidget(this.eiInstance.getEmbeddedInstance(propertyValue), propertyEntity, propertyDefinition);
                this.ontologyPanel.add((Widget)embeddedWidget);
            }
        } else {
            LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
            this.ontologyPanel.add((Widget)widget);
            boolean hadValue = false;
            for (final EIEntity propertyValue : propertyValues) {
                if (propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) continue;
                hadValue = true;
                String displayValue = this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue) ? "* " + propertyValue.getLabel() : propertyValue.getLabel();
                Anchor a = new Anchor(InstanceWidgetUtils.formatText((String)displayValue));
                if (this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue)) {
                    a.addStyleName("Stub");
                }
                widget.add((Widget)a);
                a.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent arg0) {
                        ClientRepositoryToolsManager.INSTANCE.isModelClassURI(propertyValue.getURI(), new RootAsyncCallback<Boolean>(){

                            @Override
                            public void onFailure(Throwable caught) {
                            }

                            @Override
                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    Window.open((String)(InstanceWidgetUtils.getGlossaryURL() + "#t=" + propertyValue.getURI().toString()), (String)"", (String)"");
                                } else {
                                    OntologyPropViewRenderer.this.getInstanceByURI(propertyValue);
                                }
                            }
                        });
                    }
                });
                if (hadValue) continue;
                this.ontologyPanel.remove((Widget)widget);
            }
        }
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText((String)value), InstanceWidgetUtils.formatText((String)value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText((String)InstanceWidgetUtils.insertBreaks((String)value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    private void getInstanceByURI(EIEntity entity) {
        ClientRepositoryToolsManager.INSTANCE.getInstance(entity.getURI(), new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance eiInstance) {
                if (eiInstance != null && !EIInstance.NULL_INSTANCE.equals(eiInstance)) {
                    EIEntity providerEntity = ResourceProvider.getProperResourceProviderEntity(eiInstance);
                    ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, eiInstance.getEntity(), eiInstance.getInstanceType(), providerEntity);
                }
            }
        });
    }

    public Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    public Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }

    public void addFormTitle(String type) {
        if (this.eiInstance.isEmbeddedInstance()) {
            return;
        }
        HTML stubsMessage = null;
        if (this.eiInstance.hasStubs()) {
            stubsMessage = new HTML("* This resource links to unfinished resources.");
        } else if (this.eiInstance.isStub()) {
            stubsMessage = new HTML("This resource is unfinished. Please review and save.");
        }
        if (stubsMessage != null) {
            stubsMessage.setStyleName("StubMessage");
            this.ontologyPanel.add((Widget)stubsMessage);
        }
    }

    public void fetchConstants() {
        if (ApplicationState.getInstance().getEmbeddedClasses() == null) {
            ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class", new ClientModelManager.ClassesInGroupCallback(){

                public void onSuccess(List<EIClass> result) {
                    ApplicationState.getInstance().setEmbeddedClassList(result);
                    OntologyPropViewRenderer.this.finishSetup();
                }
            });
        } else {
            this.finishSetup();
        }
    }

    protected void addNameProperty(String labelPrefix) {
        EIEntity namePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel(), (boolean)true));
        this.drawDataProperty(namePropEntity, "", true, this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
    }

    protected void addTypeProperty(String labelPrefix) {
        EIEntity typePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel(), (boolean)true));
        this.drawObjectProperty(typePropEntity, "", true, this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
    }
}

