/**
 * The eagle-i consortium
 * Harvard University
 * Apr 7, 2011
 */
package org.eaglei.datatools.datamanagment.client;

import java.util.List;

import org.eaglei.datatools.jena.BulkCurationTriple;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public class DataManagementGrid extends FlowPanel {

	public DataManagementGrid(List<BulkCurationTriple> triples) {
		if ( triples == null ) {
			return;
		}
		this.add( new Label( "Found " + triples.size() + " occurrences of the pattern" ) );
		for (BulkCurationTriple triple : triples) {
			FlowPanel row = new FlowPanel();
			// TODO change the link to be the datatools link instead of repo
			// needs server name + datatools + history (resourceUri, labUri, mode)
			// labUri is usually contained in EIInstanceMinimal but right now we are not fetching it in the queries
			row.add( new Anchor( triple.getResource().getLabel(), triple.getResource().getURI().toString() ) );
			row.add( new Label( "Type: " + triple.getType().toString() ) );
			row.add( new Label( "Predicate: " + triple.getPredicate().toString() ) );
			row.add( new Label( "Object (literal): " + triple.getLiteralObject() ) );
			row.add( new Label( "Object (resource): " + triple.getResourceObject().toString() ) );
			this.add( row );
		}
	}

}
