/**s
 * 
 */
package org.eaglei.datatools.datamanagment.server;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.rpc.DataManagmentRemoteAuthService;
import org.eaglei.datatools.client.rpc.DataManagmentRemoteService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.datatools.jena.DataManagmentProvider;
import org.eaglei.datatools.server.AbstractRemoteServiceServlet;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositoryProviderException.RepositoryProviderExceptionType;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public class DataManagmentServlet extends AbstractRemoteServiceServlet implements DataManagmentRemoteService, DataManagmentRemoteAuthService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final Log log = LogFactory.getLog( DataManagmentServlet.class );
	protected static final Log activityLogger = LogFactory.getLog( "bulk curation activity:" );
	DataManagmentConfiguration configuration;

	@Override
	public void init() {
		super.init();
		configuration = new DataManagmentConfiguration();
	}

	@Override
	public List<BulkCurationTriple> getResourcesToRepair(Session session, EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.getResourcesToRepair( session, typeURI, predicateURI, objectString, isObjectLiteral );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<BulkCurationTriple> getResourcesToRepairByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex) throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			List<BulkCurationTriple> results = dataManagmentProvider.getResourcesToRepairByRegex( session, typeURI, predicateURI, regex );
			if ( log.isDebugEnabled() ) {
				log.debug( "Returning triple list of size = " + results.size() );
			}
			return results;
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	private Session getRepositorySession() {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		User userObj = (User)httpSession.getAttribute( "user" );
		Session session = userObj.getSession();
		return session;
	}

	@Override
	public Integer replaceObject(Session session, EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.replaceObject( session, typeURI, predicateURI, oldObjectString, isOldObjectLiteral, newObjectString, isNewObjectLiteral );
		} catch (RepositoryProviderException e) {
			activityLogger.error( "there is error while performing operation 'replaceObject'" );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer replacePredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.replacePredicate( session, typeURI, oldPredicateURI, newPredicateURI, objectString, isObjectLiteral );
		} catch (RepositoryProviderException e) {
			activityLogger.error( "there is error while performing operation 'replaceObject'" );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer replaceObjectAndPredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral)
			throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.replaceObjectAndPredicate( session, typeURI, oldPredicateURI, newPredicateURI, oldObjectString, isOldObjectLiteral, newObjectString, isNewObjectLiteral );
		} catch (RepositoryProviderException e) {
			activityLogger.error( "there is error while performing operation 'replaceObject'" );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer replaceObjectByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex) throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.replaceObjectByRegex( session, typeURI, predicateURI, regex, replaceRegex );
		} catch (RepositoryProviderException e) {
			activityLogger.error( "there is error while performing operation 'replaceObject'" );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	@Override
	public Integer deleteTriple(Session session, EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.deleteTriple( session, typeURI, predicateURI, oldObjectString, isObjectLiteral );
		} catch (RepositoryProviderException e) {
			activityLogger.error( "there is error while performing operation 'replaceObject'" );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer addTriple(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException {
		try {
			DataManagmentProvider dataManagmentProvider = getCachedDataMgmtProviderOfNodeBySession( session );
			return dataManagmentProvider.addTriple( session, typeURI, oldPredicateURI, newPredicateURI, oldObjectString, isOldObjectLiteral, newObjectString, isNewObjectLiteral );

		} catch (RepositoryProviderException e) {
			activityLogger.error( "there is error while performing operation 'replaceObject'" );
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.rpc.DataManagmentService#switchServer(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public User switchServer(String node) throws ClientSideRepositoryException {
		User userToReturn;
		String tier = System.getProperty( "org.eaglei.tier" );
		String nodeURI = configuration.getNodeRepositoryURI( node );
		String nodeURL = configuration.getNodeRepositoryURL( node );
		String tierURL = RepositoryHttpConfig.computeHostURL( tier, nodeURL );
		DataManagmentRepositoryProvider.setDefaultRepositoryURI( nodeURI );
		DataManagmentRepositoryProvider.setDefaultRepositoryURL( tierURL );
		if ( !isUserOfNodeChached( tierURL ) ) {
			throw new ClientSideRepositoryException( RepositoryProviderExceptionType.INVALID_SESSION );
		} else {
			userToReturn = getCachedUserOfNode( tierURL );
			return userToReturn;

		}
	}

	@Override
	public User login(String userName, String password) throws ClientSideRepositoryException {
		try {
			User user = securityProvider.login( userName, password );
			String repositoryURL = getRepositoryURLBySession( user.getSession() );
			DataManagmentProvider dataManagmentProvider = new DataManagmentProvider( this.generalSecurityProvider, repositoryURL );

			cacheDataMgmtProviderInHttpSession( repositoryURL, dataManagmentProvider );
			cacheUserInHttpSession( repositoryURL, user );
			return user;
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e );
		}
	}

	@Override
	public void logout(Session session) throws ClientSideRepositoryException {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		httpSession.invalidate();
		super.logout( session );
	}

	private String getRepositoryURLBySession(Session session) {
		RepositoryHttpConfig httpConfig = institutionRegistry.getRepositoryHttpConfig( session.getInstitutionId() );
		return httpConfig.getHostURL();
	}

	private void cacheUserInHttpSession(String node, User user) {

		HashMap<String, User> userCache = getUserChacheMapFromSession();
		userCache.put( node, user );
		setCachedMapInSession( userCache );
	}

	private User getCachedUserOfNode(String node) {
		HashMap<String, User> userCache = getUserChacheMapFromSession();
		return userCache.get( node );
	}

	private boolean isUserOfNodeChached(String node) {
		HashMap<String, User> userCache = getUserChacheMapFromSession();
		return userCache.get( node ) != null;
	}

	private HashMap<String, User> getUserChacheMapFromSession() {
		HashMap<String, User> userCache;
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		userCache = httpSession.getAttribute( "userCache" ) == null ? new HashMap<String, User>() : (HashMap<String, User>)httpSession.getAttribute( "userCache" );
		return userCache;
	}

	private void setCachedMapInSession(HashMap<String, User> userCache) {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		httpSession.setAttribute( "userCache", userCache );
	}

	private void cacheDataMgmtProviderInHttpSession(String node, DataManagmentProvider dataMgmtProvider) {

		HashMap<String, DataManagmentProvider> dataMgmtCache = getDataMgmtProviderChacheMapFromSession();
		dataMgmtCache.put( node, dataMgmtProvider );
		setDataMgmtProviderMapInSession( dataMgmtCache );
	}

	private DataManagmentProvider getCachedDataMgmtProviderOfNodeBySession(Session session) {

		String repositoryURL = getRepositoryURLBySession( session );

		HashMap<String, DataManagmentProvider> dataMgmtCache = getDataMgmtProviderChacheMapFromSession();
		return dataMgmtCache.get( repositoryURL );
	}

	private boolean isDataMgmtProviderOfNodeChached(String node) {
		HashMap<String, DataManagmentProvider> dataMgmtCache = getDataMgmtProviderChacheMapFromSession();
		return dataMgmtCache.get( node ) != null;
	}

	private HashMap<String, DataManagmentProvider> getDataMgmtProviderChacheMapFromSession() {
		HashMap<String, DataManagmentProvider> dataMgmtCache;
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		dataMgmtCache = httpSession.getAttribute( "dataManagmentProviderCache" ) == null ? new HashMap<String, DataManagmentProvider>() : (HashMap<String, DataManagmentProvider>)httpSession.getAttribute( "dataManagmentProviderCache" );
		return dataMgmtCache;
	}

	private void setDataMgmtProviderMapInSession(HashMap<String, DataManagmentProvider> dataMgmtCache) {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		httpSession.setAttribute( "dataManagmentProviderCache", dataMgmtCache );
	}

}
