package org.eaglei.datatools.client;

import com.google.gwt.user.client.Cookies;

public class DatatoolsCookies {

	public static final String DATATOOLS_SESSION_ID = "datatools_session";
	public static final String DATATOOLS_USER_URI_ID = "datatools_userUri";
	public static final String DATATOOLS_USER_COOKIE_ID = "datatools_username";
	public static final long DURATION = 1000 * 60 * 60 * 24 * 14; //duration remembering login. 2 weeks in this example.
	
	public static boolean hasSession()
	{
		return Cookies.getCookieNames().contains(DATATOOLS_SESSION_ID);
	}
	
	public static boolean hasUserUri()
	{
		return Cookies.getCookieNames().contains(DATATOOLS_USER_URI_ID);
	}
	
	public static boolean hasUserName()
	{
		return Cookies.getCookieNames().contains(DATATOOLS_USER_COOKIE_ID);
	}
	
	public static String getSession()
	{
		return hasSession() ? Cookies.getCookie(DATATOOLS_SESSION_ID): null;
	}
	
	public static String getUserUri()
	{
		return hasUserUri() ? Cookies.getCookie(DATATOOLS_USER_URI_ID): null;
	}
	
	public static String getUserName()
	{
		return hasUserName() ? Cookies.getCookie(DATATOOLS_USER_COOKIE_ID) : null;
	}
	
	public static void removeCookies()
	{
		Cookies.removeCookie(DATATOOLS_SESSION_ID);
		Cookies.removeCookie(DATATOOLS_USER_COOKIE_ID);
		Cookies.removeCookie(DATATOOLS_USER_URI_ID);
		
	}
}
