package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The client side stub for the RPC service.
 */
public interface RepositoryToolsModelServiceAsync {
	

	@Deprecated
    public void getAllResources(String session, String rnav, AsyncCallback<List<EIInstance>> callback);
	@Deprecated
    public void getResourcesOfClass(String session, String rnav, EIURI classUri, AsyncCallback<List<EIInstance>> callback);

	public void EIQuery(String session, String query, AsyncCallback<List<EIInstance>> callback);
	
	public void retrieveLabel(String session, EIURI uri, AsyncCallback<String> callback);
    
    /*
     * instance functionality
     */

   
    public void getNewInstanceID(String session, int count, AsyncCallback<List<EIURI>> callback) throws Exception ;;
    public void getEmptyEIInstance(String session, EIURI classUri, EIEntity instanceEntity, AsyncCallback<EIInstance> asyncCallback);;
    public void getInstance(String session, EIURI instanceID, AsyncCallback<EIInstance> callback) throws Exception ;;
    public void updateInstance(String session, EIInstance instance, String token, AsyncCallback<String> callback) throws Exception ;;
    public void createInstance(String session, EIInstance instance, AsyncCallback callback) throws Exception ;;
    public void deleteInstance(String session, EIInstance instance, AsyncCallback callback) throws Exception ;;
    
    public void getInstancesForLab(String session, String rnav, String labUri, AsyncCallback<List<EIInstance>> instances) throws Exception;
    public void getFilterQuery(final String session, final String user, final EIURI classUri, final EIURI state, final EIURI lab,AsyncCallback<List<EIInstance>> instances) throws Exception;
    /*
     * free form SPARQL end point
     */

    
    public void query(String session, String sparql, AsyncCallback<String> callback) throws Exception ;;
    
    public void uploadInstances(String session, String rdf, AsyncCallback<Void> callback) throws Exception ;;
    
    /*
     * login/logout etc
     */
    public void login(String user, String password, AsyncCallback<String[]> callback) throws Exception ;;    
    public void logout(String session, AsyncCallback callback) throws Exception ;;
    public void whoami(String session, AsyncCallback callback) throws Exception ;;
    public void isOnline(AsyncCallback callback) throws Exception ;;
    
    /*
     * workflow fake REST API
     */
    
    public void promote(String session, String uri, String newState, AsyncCallback<String> callback) throws Exception;;;
    public void bulkPromote(String session, String[] uri, String newState, AsyncCallback<String[]> callback) throws Exception;;
    public void claim(String session, String uri, String claimant, AsyncCallback<String> callback) throws Exception;; 
    public void getWFStates(String session, String user, AsyncCallback<String[]> callback) throws Exception;
}
