package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.IdCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.NewInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Creates a Form Panel. This is a common class for Labs & Resources
 * 
 * @author pp101
 *
 */
public class FormsPanel implements ClientRepositoryToolsManager.SessionListener{

	public static EIClass resourceClass;
	public static String labUri = "";
	private String resourceType;
	public static EIURI eiURI;
	public static EIInstance eiInstance;
	String token;
	private boolean signedIn = false;
	public static VerticalPanel testPanel;
	
	public static VerticalPanel vp = new VerticalPanel();
	
	public FormsPanel(String labUri,String uri){ 
		this.labUri = labUri;
		eiURI = EIURI.create(uri);
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
	}
	
	public FormsPanel() {
		
	}
	
	/**
	 * Generates a new form based on the URI passed.
	 * @return
	 */
	public VerticalPanel generateNewForm() { 
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		vp.setSpacing(30);
		vp.setHeight("50"); 
		// Set eiInstance to null in order to differentiate between add form and edit form
		eiInstance = null; 
		FormUtils.dataList.clear();
		FormUtils.objList.clear();
		FormUtils.formName = "";
		ClientOntologyToolsManager.INSTANCE.getEIClass(eiURI, new EIClassCallback(){ 
        @Override
        public void onSuccess(EIClass result) {
        		resourceClass = result;
        		Log.info("forms panel got EIClass for: " + result.getEntity().getLabel());
    			vp.add(FormUtils.displayDefaultFields(resourceClass,"","",null,false));
    			vp.add(FormUtils.displayFormFields(resourceClass, null, false));
        }
        @Override
		public void onFailure(String result) {
			// TODO Auto-generated method stub
		}
       });
		return vp;
	}

	/**
	 * This method creates a form to edit. The values of fields will be prepopulated.
	 * @param eiuri
	 * @return
	 */
	public VerticalPanel generateEditForm(String eiuri) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		EIURI uri = EIURI.create(eiuri);

		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback(){
				@Override
				public void onSuccess(final EIInstance instance) { 
					eiInstance = instance; 
					ClientOntologyToolsManager.INSTANCE.getEIClass(instance.getInstanceType().getURI(), new EIClassCallback() {
						
						@Override
						public void onSuccess(EIClass result) {
							resourceClass = result;  
							if(result.hasSuperClass()){
								ClientOntologyToolsManager.INSTANCE.getSuperClass(result, new EISuperClassCallback() {
									@Override
									public void onSuccess(EIClass superClass) {
										FormUtils.dataList.clear();
										FormUtils.objList.clear(); 
										vp.add(FormUtils.displayDefaultFields(superClass,instance.getInstanceLabel(),"",instance.getInstanceType().getURI(), false));
										
										vp.add(FormUtils.displayFormFields(resourceClass, instance,false));
										
										VerticalPanel nonOntPanel = new VerticalPanel();
										nonOntPanel.setStyleName("nonOntPanel");
										nonOntPanel.add(FormUtils.displayNonOntologyProperties(eiInstance));
										vp.add(nonOntPanel);
										
										FormsPanel.this.vp=vp;
									}
								});
							} else {
								FormUtils.dataList.clear();
								FormUtils.objList.clear(); 
								vp.add(FormUtils.displayDefaultFields(resourceClass,instance.getInstanceLabel(),"",instance.getInstanceType().getURI(), false));
								vp.add(FormUtils.displayFormFields(resourceClass, instance,false));
								
								VerticalPanel nonOntPanel = new VerticalPanel();
								nonOntPanel.setStyleName("nonOntPanel");
								nonOntPanel.add(FormUtils.displayNonOntologyProperties(eiInstance));
								vp.add(nonOntPanel);
								FormsPanel.this.vp=vp;
							}
						}  
						
						@Override
						public void onFailure(String result) {
							// TODO Auto-generated method stub
							
						}
					});
				}

				@Override
				public void loginRequired() {
					handleLoginRequired();
					
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace(); 
		}
		
		return vp;
	}
	
	/**
	 * This method creates a form in 'view' mode. The fields are not editable
	 * @param eiuri
	 * @return
	 */
	public VerticalPanel generateViewForm(final EIInstance eiInstance) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		FormsPanel.eiInstance = eiInstance; // TODO: why was this not?
		if(eiInstance.getInstanceType().getLabel().equalsIgnoreCase("laboratory")){
			labUri = eiInstance.getInstanceURI().toString();
		}
		ClientOntologyToolsManager.INSTANCE.getEIClass(eiInstance.getInstanceType().getURI(), new EIClassCallback() {
			@Override
			public void onSuccess(EIClass result) {
				resourceClass = result;
				FormUtils.dataList.clear();
				FormUtils.objList.clear(); 
				vp.add(FormUtils.displayDefaultFields(resourceClass,eiInstance.getInstanceLabel(),eiInstance.getInstanceURI().toString(),eiInstance.getInstanceType().getURI(), true));
				vp.add(FormUtils.displayFormFields(resourceClass, eiInstance,true));
				
				VerticalPanel nonOntPanel = new VerticalPanel();
				nonOntPanel.setStyleName("nonOntPanel");
				nonOntPanel.add(FormUtils.displayNonOntologyProperties(eiInstance));
				vp.add(nonOntPanel);
			}
			
			@Override
			public void onFailure(String result) {
				// TODO Auto-generated method stub
			}
		});
		return vp;
	}
	
	public void saveForm() throws Exception{ 
		if(FormUtils.formName!=null && !FormUtils.formName.equals("")){ 
			// Edit form
			if(eiInstance!=null){
				eiInstance.setInstanceType(EIEntity.create(FormUtils.subType, ""));
				
				eiInstance.setNonOntologyLiteralProperties(FormUtils.nonOntLiteralList);
				eiInstance.setNonOntologyResourceProperties(FormUtils.nonOntResourceList);
				Map<EIEntity,Set<String>> dataMap = new HashMap<EIEntity,Set<String>>();
				for(TextBox tb:FormUtils.dataList){
					String name = tb.getName(); 
						EIEntity entity = EIEntity.create(name.substring(0,name.indexOf("|")), name.substring(name.indexOf("|")+1));
						if(dataMap.containsKey(entity)){
							Set<String> st = dataMap.get(entity);
							st.add(tb.getText());

						} else {
							Set<String> st = new HashSet<String>();
							st.add(tb.getText()); 
							dataMap.put(entity, st);    
						}
				}
				eiInstance.setLabel(FormUtils.formName);
				
				Map<EIEntity,Set<EIURI>> objMap = new HashMap<EIEntity,Set<EIURI>>();
				for(ListBox lb:FormUtils.objList){ 
					String name = lb.getName(); 
					EIEntity entity = EIEntity.create(name.substring(0,name.indexOf("|")), name.substring(name.indexOf("|")+1));
					if(!lb.getValue(lb.getSelectedIndex()).equals("")){
						if(objMap.containsKey(entity)){
							Set<EIURI> st = objMap.get(entity);
							st.add(EIURI.create(lb.getValue(lb.getSelectedIndex())));
						} else {
							Set<EIURI> st = new HashSet<EIURI>();
							st.add(EIURI.create(lb.getValue(lb.getSelectedIndex()))); 
							objMap.put(entity, st); 
						}
					}
				}
				eiInstance.setDatatypeProperties(dataMap);
				eiInstance.setObjectProperties(objMap);
				ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, null, new ResultsCallback(){
					@Override
					public void loginRequired() {
					}
					@Override
					public void onSuccess(String[] arg0) {
					
					}
					@Override
					public void onSuccess(String arg0) { 
						token = arg0; 
						try {
							ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, token, new ResultsCallback(){
								@Override
								public void onSuccess(String str) {
									MainPanel.dataPanel.clear();
									FilterPanel fp = new FilterPanel(getWFStateString(eiInstance), (eiInstance.getWFOwner() != null));
									MainPanel.dataPanel.add(fp);
									fp.editButton.setVisible(true);
									fp.saveButton.setVisible(false);
									HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
									MainPanel.dataPanel.add(msg);
									MainPanel.dataPanel.add(generateViewForm(eiInstance)); 
								}
								@Override
								public void loginRequired() {
								}
								@Override
								public void onSuccess(String[] arg0) { 
									MainPanel.dataPanel.clear();
									FilterPanel fp = new FilterPanel(getWFStateString(eiInstance), (eiInstance.getWFOwner() != null));
									MainPanel.dataPanel.add(fp);
									fp.editButton.setVisible(true);
									fp.saveButton.setVisible(false);
									HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
									MainPanel.dataPanel.add(msg);
									MainPanel.dataPanel.add(generateViewForm(eiInstance));
									MainPanel.instanceUri = eiInstance.getInstanceURI().toString();
								}
							});
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				});
			} else { //New Form
				ClientRepositoryToolsManager.INSTANCE.getNewInstanceID(1, new IdCallback(){
					@Override
					public void loginRequired() { 
						handleLoginRequired();
					}
	
					@Override
					public void onSuccess(List<EIURI> list) {
						
						EIURI uri = resourceClass.getEntity().getURI();  
						if(FormUtils.subType!=null)
							uri = FormUtils.subType;
						ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(uri, EIEntity.create(list.get(0), FormUtils.formName),  new EIInstanceCallback(){
							@Override
							public void onSuccess(final EIInstance instance) {
								Map<EIEntity,Set<String>> dataMap = new HashMap<EIEntity,Set<String>>();
								for(TextBox tb:FormUtils.dataList){
									String name = tb.getName();
										EIEntity entity = EIEntity.create(name.substring(0,name.indexOf("|")), name.substring(name.indexOf("|")+1));
										if(dataMap.containsKey(entity)){
											Set<String> st = dataMap.get(entity);
											st.add(tb.getText());

										} else {
											Set<String> st = new HashSet<String>();
											st.add(tb.getText()); 
											dataMap.put(entity, st);
										}
								}
								
								for(EIEntity entity: dataMap.keySet()){
									for(String value:dataMap.get(entity)){
										instance.addDatattypePropertyToInstance(entity, value);
									}
								}
								
								Map<EIEntity,Set<EIURI>> objMap = new HashMap<EIEntity,Set<EIURI>>();
								for(ListBox lb:FormUtils.objList){
									String name = lb.getName(); 
									EIEntity entity = EIEntity.create(name.substring(0,name.indexOf("|")), name.substring(name.indexOf("|")+1));
									
									if(!lb.getValue(lb.getSelectedIndex()).equals("")){ 
										if(objMap.containsKey(entity)){
											Set<EIURI> st = objMap.get(entity);
											st.add(EIURI.create(lb.getValue(lb.getSelectedIndex())));
										} else {
											Set<EIURI> st = new HashSet<EIURI>();
											st.add(EIURI.create(lb.getValue(lb.getSelectedIndex()))); 
											objMap.put(entity, st);
										}
									}
								}
								for(EIEntity entity: objMap.keySet()){ 
									for(EIURI uri:objMap.get(entity)){
										instance.addObjectPropertyToInstance(entity, uri);	
									}
								}
								
								ClientRepositoryToolsManager.INSTANCE.createInstance(instance, new NewInstanceCallback() {
									@Override
									public void onSuccess(Object o) {
										MainPanel.dataPanel.clear();
										FilterPanel fp = new FilterPanel(getWFStateString(instance), (instance.getWFOwner() == null));
										MainPanel.dataPanel.add(fp);
										fp.editButton.setVisible(true);
										fp.saveButton.setVisible(false);
										HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
										MainPanel.dataPanel.add(msg);
										try {
											ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback(){
												@Override
												public void onSuccess(EIInstance eiInstance) {
													MainPanel.dataPanel.add(generateViewForm(eiInstance));
												}

												@Override
												public void loginRequired() {
													// TODO Auto-generated method stub
												}
												
											});
										} catch (Exception e) {
											// TODO Auto-generated catch block
											e.printStackTrace();
										}
										
										MainPanel.instanceUri = instance.getInstanceURI().toString();
									}
	
									@Override
									public void loginRequired() {
										
									}
								});
							}
	
							@Override
							public void loginRequired() {
								handleLoginRequired();
								
							}
						});
					}
				});
			}
		 }
		 else {
    		Window.alert(WorkFlowConstants.LABEL_REQUIRED);
    	}
	}
	
    public void setLoggedOut() {
    }
    
	private void handleLoginRequired() {
		// TODO: what's the real behavior?
		Window.alert(WorkFlowConstants.PLEASE_LOGIN);
		//setLoggedOut();
	}
    
	@Override
	public void onLogOut() {
		signedIn = false;
		setLoggedOut();
	}

	@Override
	public void onLogIn(String username, String userUri) {
		signedIn = true;
	}

	private String getWFStateString(final EIInstance instance) {
		return instance.getWFState()==null?"":instance.getWFState().toString();
	}
}

