package org.eaglei.datatools.server;




import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.client.rpc.OntologyToolsModelService;
import org.eaglei.datatools.model.DataToolsEIOntModel;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class OntologyToolsModelServlet extends RemoteServiceServlet implements OntologyToolsModelService{

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
	 * 
	 */
	protected static final Log logger = LogFactory.getLog(OntologyToolsModelServlet.class);
	
    private DataToolsEIOntModel datatoolsEIOntModel;
    
    @Override
    public void init() {
        WebApplicationContext ctx = 
            WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        datatoolsEIOntModel = ctx.getBean(DataToolsEIOntModel.class);
        // hack to get the ref passed along to other code
        DataToolsEIOntModel.INSTANCE = datatoolsEIOntModel;
    }

	@Override
	public List<EIClass> getTopLevelClasses()  {
		 try { 
	            return datatoolsEIOntModel.getTopLevelClasses();
	        } catch (Throwable t) {
	            logger.error("Error in getTopLevelClasses: ", t);
	            return null;
	           // throw new Exception();
	        }
	}

	@Override
	public EIClass getEIClass(EIURI uri) {
		return datatoolsEIOntModel.getClass(uri);
	}
	
	@Override
	public List<EIProperty> getProperties(EIURI classId) {
        try {
        	List<EIProperty> prop = datatoolsEIOntModel.getProperties(classId);
            return datatoolsEIOntModel.getProperties(classId);
        } catch (Throwable t) {
            logger.error("Error in getProperties: " + classId, t);
        }
		return null;
    }
	
	@Override
	public List<EIProperty> getProperties(EIURI classId, String groupUri) {
        try {
            return datatoolsEIOntModel.getProperties(classId, groupUri);
        } catch (Throwable t) {
            logger.error("Error in getProperties: " + classId, t);
        }
		return null;
    }

	@Override
	public List<EIClass> getSubClasses(EIURI classId, boolean resolveReference)  {
		 try { 
	            return datatoolsEIOntModel.getSubClasses(classId);
	        } catch (Throwable t) {
	        	logger.error("Error in getTopLevelClasses: ", t);
	            return null;
	           // throw new Exception();
	        }
	}

	@Override
	public List<String> getClassDefinitions(List<EIURI> classURIs)
			throws Exception {
		return datatoolsEIOntModel.getClassDefinitions(classURIs);
	}

	@Override
	public EIClass getSuperClass(EIClass eclass) {
		while(eclass.hasSuperClass()) { 
			eclass = datatoolsEIOntModel.getSuperClass(eclass);
		}
		return eclass;
	}
}
