/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.client.rpc.OntologyToolsModelService;
import org.eaglei.datatools.model.DataToolsEIOntModel;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OntologyToolsModelServlet
extends RemoteServiceServlet
implements OntologyToolsModelService {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(OntologyToolsModelServlet.class);
    private DataToolsEIOntModel datatoolsEIOntModel;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        DataToolsEIOntModel.INSTANCE = this.datatoolsEIOntModel = (DataToolsEIOntModel)ctx.getBean(DataToolsEIOntModel.class);
    }

    public List<EIClass> getTopLevelClasses() {
        try {
            return this.datatoolsEIOntModel.getTopLevelClasses();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getTopLevelClasses: ", t);
            return null;
        }
    }

    public EIClass getEIClass(EIURI uri) {
        return this.datatoolsEIOntModel.getClass(uri);
    }

    public List<EIProperty> getProperties(EIURI classId) {
        try {
            List prop = this.datatoolsEIOntModel.getProperties(classId);
            return this.datatoolsEIOntModel.getProperties(classId);
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getProperties: " + classId), t);
            return null;
        }
    }

    public List<EIProperty> getProperties(EIURI classId, String groupUri) {
        try {
            return this.datatoolsEIOntModel.getProperties(classId, groupUri);
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getProperties: " + classId), t);
            return null;
        }
    }

    public List<EIClass> getSubClasses(EIURI classId, boolean resolveReference) {
        try {
            return this.datatoolsEIOntModel.getSubClasses(classId);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getTopLevelClasses: ", t);
            return null;
        }
    }

    public List<String> getClassDefinitions(List<EIURI> classURIs) throws Exception {
        return this.datatoolsEIOntModel.getClassDefinitions(classURIs);
    }

    public EIClass getRootSuperClass(EIClass eclass) {
        while (eclass.hasSuperClass()) {
            eclass = this.datatoolsEIOntModel.getSuperClass(eclass);
        }
        return eclass;
    }

    public EIClass getSuperClass(EIClass eclass) {
        eclass = this.datatoolsEIOntModel.getSuperClass(eclass);
        return eclass;
    }
}

