package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.IdCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.NewInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Creates a Form Panel. This is a common class for Labs & Resources
 * 
 * @author pp101
 * 
 */
public class FormsPanel extends Composite implements ClientRepositoryToolsManager.SessionListener {
	private final VerticalPanel outer = new VerticalPanel();
    public EIClass			resourceClass;
	public String			labUri		= "";
	private String			resourceType;
	public EIURI			eiURI;
	public EIInstance		eiInstance;
	String					token;
	private boolean			signedIn	= false;
	public VerticalPanel	testPanel;
	public VerticalPanel	vp;
	public FormUtils		frmUtils;
	public FormsPanel(String labUri, String uri) {
		this.labUri = labUri;
		vp = new VerticalPanel();
		eiURI = EIURI.create(uri);
		frmUtils = new FormUtils(this);
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
	}
	public FormsPanel() {
		initWidget(outer);
		frmUtils = new FormUtils(this);
		outer.add(frmUtils.formFieldsPanel);
	}
	/**
	 * Generates a new form based on the URI passed.
	 * 
	 * @return
	 */
	public VerticalPanel generateNewForm() {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		vp.setSpacing(30);
		vp.setHeight("50");
		
		// Set eiInstance to new instance
		frmUtils.objList.clear();
		frmUtils.formName = "";
		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(eiURI, new EIInstanceCallback() {
			@Override
			public void onSuccess(EIInstance newInstance) {
				eiInstance = newInstance;
				resourceClass = eiInstance.getInstanceClass();
				Log.info("Class from new empty instance was " + resourceClass);
				vp.add(frmUtils.displayDefaultFields(eiInstance, resourceClass, "", "", null, false));
				vp.add(frmUtils.displayFormFields(resourceClass, eiInstance, false)); // TODO: restore!
			}

			@Override
			public void loginRequired() {
				// TODO Auto-generated method stub
				
			}
			
		});
		return vp;
	}
	/**
	 * This method creates a form to edit. The values of fields will be
	 * prepopulated.
	 * 
	 * @param eiuri
	 * @return
	 */
	public VerticalPanel generateEditForm(String eiuri) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		EIURI uri = EIURI.create(eiuri);
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance instance) {
					eiInstance = instance;
					ClientOntologyToolsManager.INSTANCE.getEIClass(instance.getInstanceType().getURI(), new EIClassCallback() {
						@Override
						public void onSuccess(EIClass result) {
							resourceClass = result;
							if (result.hasSuperClass()) {
								ClientOntologyToolsManager.INSTANCE.getRootSuperClass(result, new EISuperClassCallback() {
									@Override
									public void onSuccess(EIClass superClass) {
										displayEditContents(vp, instance, superClass);
									}
								});
							} else {
								displayEditContents(vp, instance, resourceClass);
							}
						}
						@Override
						public void onFailure(String result) {
							// TODO Auto-generated method stub
						}
					});
				}
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return vp;
	}
	
	private void displayEditContents(final VerticalPanel vp, final EIInstance instance, final EIClass rootClass) {
		frmUtils.objList.clear();
		vp.add(frmUtils.displayDefaultFields(eiInstance, rootClass, instance.getInstanceLabel(), "", instance.getInstanceType().getURI(), false));
		vp.add(frmUtils.displayFormFields(resourceClass, eiInstance, false));
		VerticalPanel nonOntPanel = new VerticalPanel();
		nonOntPanel.setStyleName("nonOntPanel");
		nonOntPanel.add(frmUtils.displayNonOntologyProperties(eiInstance));
		vp.add(nonOntPanel);
		FormsPanel.this.vp = vp;
	}
	/**
	 * This method creates a form in 'view' mode. The fields are not editable
	 * 
	 * @param eiuri
	 * @return
	 */
	public VerticalPanel generateViewForm(final EIInstance instance) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		this.eiInstance = instance; // TODO: why was this not?
		if (eiInstance.getInstanceType().getLabel().equalsIgnoreCase("laboratory")) {
			labUri = eiInstance.getInstanceURI().toString();
		}
		ClientOntologyToolsManager.INSTANCE.getEIClass(eiInstance.getInstanceType().getURI(), new EIClassCallback() {
			@Override
			public void onSuccess(EIClass result) {
				resourceClass = result;
				frmUtils.objList.clear();
				vp.add(frmUtils.displayDefaultFields(eiInstance, resourceClass, instance.getInstanceLabel(), instance.getInstanceURI().toString(), instance.getInstanceType().getURI(), true));
				vp.add(frmUtils.displayFormFields(resourceClass, eiInstance, true));
				VerticalPanel nonOntPanel = new VerticalPanel();
				nonOntPanel.setStyleName("nonOntPanel");
				nonOntPanel.add(frmUtils.displayNonOntologyProperties(eiInstance));
				vp.add(nonOntPanel);
				frmUtils.clearAll();
			}
			@Override
			public void onFailure(String result) {
				// TODO Auto-generated method stub
			}
		});
		return vp;
	}
	
	public void saveForm() throws Exception {
		if (frmUtils.formName != null && !frmUtils.formName.equals("")) {
			// Edit form
			if (eiInstance.getWFState() != null) {
				Log.info("edit mode save");
				ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, null, new ResultsCallback() {
					@Override
					public void loginRequired() {
					}
					@Override
					public void onSuccess(String[] arg0) {
					}
					@Override
					public void onSuccess(String arg0) {
						token = arg0;
						try {
							ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, token, new ResultsCallback() {
								@Override
								public void onSuccess(String str) {
									MainPanel.dataPanel.clear();
									FilterPanel fp = new FilterPanel(getWFStateString(eiInstance), (eiInstance.getWFOwner() != null));
									MainPanel.dataPanel.add(fp);
									fp.editButton.setVisible(true);
									fp.saveButton.setVisible(false);
									HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
									MainPanel.dataPanel.add(msg);
									try {
										ClientRepositoryToolsManager.INSTANCE.getInstance(eiInstance.getInstanceURI(), new EIInstanceCallback() {
											@Override
											public void onSuccess(EIInstance fetchedInstance) {
												viewAfterUpdate(fetchedInstance);
											}
											@Override
											public void loginRequired() {
												// TODO Auto-generated
												// method stub
											}
										});
									} catch (Exception e) {
										Log.error("could not (re-) get instance");
									}
								}
								@Override
								public void loginRequired() {
								}
								@Override
								public void onSuccess(String[] arg0) {
									viewAfterSave(true);
								}
							});
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				});
			} else { //New Form
				Log.info("new form stuff; getting ready to save instance with label " + eiInstance.getInstanceLabel());
				ClientRepositoryToolsManager.INSTANCE.createInstance(eiInstance, new NewInstanceCallback() {
					@Override
					public void onSuccess(Object o) {
						MainPanel.dataPanel.clear();
						FilterPanel fp = new FilterPanel(getWFStateString(eiInstance), (eiInstance.getWFOwner() == null));
						MainPanel.dataPanel.add(fp);
						fp.editButton.setVisible(true);
						fp.saveButton.setVisible(false);
						HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
						MainPanel.dataPanel.add(msg);
						try {
							ClientRepositoryToolsManager.INSTANCE.getInstance(eiInstance.getInstanceURI(), new EIInstanceCallback() {
								@Override
								public void onSuccess(EIInstance fetched) {
									MainPanel.instanceUri = fetched.getInstanceURI().toString();
									MainPanel.dataPanel.add(generateViewForm(fetched));
								}
								@Override
								public void loginRequired() {
									// TODO Auto-generated method stub
								}
							});
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						
					}
					@Override
					public void loginRequired() {
					}
				});
			}
		} else {
			Window.alert(WorkFlowConstants.LABEL_REQUIRED);
		}
	}
	public void setLoggedOut() {
	}
	private void handleLoginRequired() {
		// TODO: what's the real behavior?
		Window.alert(WorkFlowConstants.PLEASE_LOGIN);
		//setLoggedOut();
	}
	@Override
	public void onLogOut() {
		signedIn = false;
		setLoggedOut();
	}
	@Override
	public void onLogIn(String username, String userUri) {
		signedIn = true;
	}
	public static String getWFStateString(final EIInstance instance) {
		return instance.getWFState() == null ? "" : instance.getWFState().toString();
	}
	public EIClass getResourceClass() {
		return resourceClass;
	}
	public void setResourceClass(EIClass resourceClass) {
		this.resourceClass = resourceClass;
	}
	public String getLabUri() {
		return labUri;
	}
	public void setLabUri(String labUri) {
		this.labUri = labUri;
	}
	public String getResourceType() {
		return resourceType;
	}
	public void setResourceType(String resourceType) {
		this.resourceType = resourceType;
	}
	public EIURI getEiURI() {
		return eiURI;
	}
	public void setEiURI(EIURI eiURI) {
		this.eiURI = eiURI;
	}
	public EIInstance getEiInstance() {
		return eiInstance;
	}
	public void setEiInstance(EIInstance eiInstance) {
		this.eiInstance = eiInstance;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public boolean isSignedIn() {
		return signedIn;
	}
	public void setSignedIn(boolean signedIn) {
		this.signedIn = signedIn;
	}
	public VerticalPanel getTestPanel() {
		return testPanel;
	}
	public void setTestPanel(VerticalPanel testPanel) {
		this.testPanel = testPanel;
	}
	public VerticalPanel getVp() {
		return vp;
	}
	public void setVp(VerticalPanel vp) {
		this.vp = vp;
	}
	public FormUtils getFrmUtils() {
		return frmUtils;
	}
	public void setFrmUtils(FormUtils frmUtils) {
		this.frmUtils = frmUtils;
	}
	public boolean onCreateNewClicked(final EIInstance parentInstance, final EIEntity property, final EIClass range, final ListBox subClassList, final TextBox textBox, Hidden oldValue) {
		FormUtils frmUtilsForDailog = new FormUtils(new FormsPanel());
		frmUtilsForDailog.createDialog(parentInstance, property, range, subClassList, textBox, oldValue);
		return true;
	}
	public void viewAfterSave(boolean showSucessMsg) {
		MainPanel.dataPanel.clear();
		FilterPanel fp = new FilterPanel(getWFStateString(eiInstance), (eiInstance.getWFOwner() != null));
		MainPanel.dataPanel.add(fp);
		fp.editButton.setVisible(true);
		fp.saveButton.setVisible(false);
		if(showSucessMsg)
		{
			HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
			MainPanel.dataPanel.add(msg);	
		}
		
		MainPanel.dataPanel.add(generateViewForm(eiInstance));
		MainPanel.instanceUri = eiInstance.getInstanceURI().toString();
	}
	public void viewAfterUpdate(EIInstance fetchedInstance) {
		eiInstance = fetchedInstance;
		MainPanel.dataPanel.add(generateViewForm(eiInstance));
	}
}
