package org.eaglei.datatools.client.rpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

//TODO remove
import com.allen_sauer.gwt.log.client.Log;

/**
 * Maintains a client-side cache of EIClasses. Proxies all model RPC methods.
 * 
 * It is critical that all model RPC calls go through this class. All methods in
 * this class MUST call getCached(EIClass) on all EIClass objects it receives
 * from the server to ensure that there is only one instance of an EIClass per
 * URI in the client.
 * 
 * 
 */
public class ClientOntologyToolsManager {
	public interface TopLevelClassesCallback {
		void onSuccess(List<EIClass> result);
	}

	public interface EIClassCallback {
		void onSuccess(EIClass result);

		void onFailure(String result);
	}

	public interface PropertyCallback {
		void onSuccess(EIClass result);
	}

	public interface EISubClassCallback {
		void onSuccess(List<EIClass> result);
	}

	public interface EISuperClassCallback {
		void onSuccess(EIClass result);
	}

	public interface DefinitionsCallback {
		void onSuccess(List<EIClass> result);
	}

	public static final ClientOntologyToolsManager INSTANCE = new ClientOntologyToolsManager();
	protected static OntologyToolsModelServiceAsync modelService;
	private List<EIEntity> listInstitutions = null;
	private List<EIClass> listTopLevelClasses = null;
	private final HashMap<EIURI, EIClass> mapIdToClass = new HashMap<EIURI, EIClass>();
	private EIClass eiClass = null;

	private ClientOntologyToolsManager() {
		modelService = GWT.create(OntologyToolsModelService.class);
	}

	public void getTopLevelClasses(final TopLevelClassesCallback callback) {
		if (listTopLevelClasses != null) {
			DeferredCommand.addCommand(new Command() {
				public void execute() {
					//Log.info("about to handle top level classes without round trip"); // TODO: remove
					callback.onSuccess(listTopLevelClasses);
				}
			});
		} else {
			modelService.getTopLevelClasses(new AsyncCallback<List<EIClass>>() {
				public void onFailure(Throwable caught) {
					// TODO Auto-generated method stub
					System.out.println(caught.getLocalizedMessage());
				}

				public void onSuccess(List<EIClass> result) {
					// Ensure that we only have a single instance of the
					// EIClass object in the client.
					// Avoids losing cached info.
					List<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
					for (EIClass c : result) {
						cacheResults.add(c);
					}
					listTopLevelClasses = cacheResults;
					//Log.info("about to handle top level classes WITH round trip"); // TODO: remove
					callback.onSuccess(listTopLevelClasses);
				}
			});
		}
	}

	public void getEIClass(final EIURI id, final EIClassCallback callback) {
		modelService.getEIClass(id, new AsyncCallback<EIClass>() {
			public void onFailure(Throwable caught) {
				callback.onFailure(caught.getMessage());
			}

			public void onSuccess(EIClass result) {
				//callback.onSuccess(getCached(result));
				callback.onSuccess(result);
			}
		});
	}

	/**
	 * Call this to ensure that the properties list of a given EIClass has been
	 * populated.
	 * 
	 * Note that if EIClass.hasProperty() is false, the value of
	 * EIClass.getProperties() is undefined (probably null).
	 * 
	 * @param resource
	 * @param callback
	 */
	public void getProperties(final EIClass resource,
			final PropertyCallback callback) {
		if (!resource.hasProperty() || resource.getProperties() != null) {
			DeferredCommand.addCommand(new Command() {
				public void execute() {
					callback.onSuccess(resource);
				}
			});
		} else {
			modelService.getProperties(resource.getEntity().getURI(),
					new AsyncCallback<List<EIProperty>>() {
						public void onFailure(Throwable caught) {
							Window.alert(caught.getLocalizedMessage());
							// TODO Auto-generated method stub
						}

						public void onSuccess(List<EIProperty> result) {
							// Ensure that we only have a single instance of the
							// EIClass object in the client.
							// Avoids losing cached info.
							resource.setProperties(result);
							callback.onSuccess(resource);
						}
					});
		}
	}

	public void getProperties(final EIClass resource, String groupUri,
			final PropertyCallback callback) {
		if (!resource.hasProperty() || resource.getProperties() != null) {
			DeferredCommand.addCommand(new Command() {
				public void execute() {
					callback.onSuccess(resource);
				}
			});
		} else {
			modelService.getProperties(resource.getEntity().getURI(), groupUri,
					new AsyncCallback<List<EIProperty>>() {
						public void onFailure(Throwable caught) {
							// TODO Auto-generated method stub
						}

						public void onSuccess(List<EIProperty> result) {
							// Ensure that we only have a single instance of the
							// EIClass object in the client.
							// Avoids losing cached info.
							resource.setProperties(result);
							callback.onSuccess(resource);
						}
					});
		}
	}

	public void getClassDefinitions(final List<EIClass> classList,
			final DefinitionsCallback callback) {
		ArrayList<EIURI> classURIList = new ArrayList<EIURI>(classList.size());
		for (EIClass clazz : classList) {
			classURIList.add(clazz.getEntity().getURI());
		}
		modelService.getClassDefinitions(classURIList,
				new AsyncCallback<List<String>>() {
					@Override
					public void onFailure(Throwable arg0) {
						// TODO Auto-generated method stub
					}

					@Override
					public void onSuccess(List<String> result) {
						int index = 0;
						for (EIClass clazz : classList) {
							clazz.setDefinition(result.get(index++));
						}
						callback.onSuccess(classList);
					}
				});
	}

	public void getSubClasses(final EIURI classId, boolean resolveReference,
			final EISubClassCallback callback) {
		modelService.getSubClasses(classId, resolveReference,
				new AsyncCallback<List<EIClass>>() {
					public void onFailure(Throwable caught) {
						// TODO Auto-generated method stub
					}

					public void onSuccess(List<EIClass> result) {
						callback.onSuccess(result);
					}
				});
	}

	public void getSuperClass(final EIClass eclass,
			final EISuperClassCallback callback) {
		modelService.getSuperClass(eclass, new AsyncCallback<EIClass>() {
			public void onFailure(Throwable caught) {
				// TODO Auto-generated method stub
			}

			public void onSuccess(EIClass result) {
				callback.onSuccess(result);
			}
		});
	}
	
	public void getRootSuperClass(final EIClass eclass,	final EISuperClassCallback callback) {
		modelService.getRootSuperClass(eclass, new AsyncCallback<EIClass>() {
			public void onFailure(Throwable caught) {
				// TODO Auto-generated method stub
			}

			public void onSuccess(EIClass result) {
				callback.onSuccess(result);
			}
		});
	}

	private List<EIProperty> getCached(List<EIProperty> propList) {
		for (EIProperty p : propList) {
			if (p instanceof EIObjectProperty) {
				EIObjectProperty op = (EIObjectProperty) p;
				EIClass c = op.getRange();
				// Replace the range class instance with cached one,
				// if one is there.
				// Otherwise cache this new class instance.
				op.setRange(getCached(c));
			}
		}
		return propList;
	}

	private EIClass getCached(EIClass c) {
		if (mapIdToClass.containsKey(c.getEntity().getURI())) {
			return mapIdToClass.get(c.getEntity().getURI());
		} else {
			mapIdToClass.put(c.getEntity().getURI(), c);
			return c;
		}
	}
}
